//LabPlot : RegressionListDialog.h

#ifndef REGRESSIONLISTDIALOG_H
#define REGRESSIONLISTDIALOG_H

#include "ListDialog.h"

class RegressionListDialog : public ListDialog
{
	Q_OBJECT
public:
	RegressionListDialog(MainWin *mw, const char *name);
public slots:
	void setRegion(double a, double b) {							//!< set region to use
		regionminle->setText(QString::number(a));
		regionmaxle->setText(QString::number(b));
	}
	void setModel(int m) { modelcb->setCurrentItem(m); }				//!< set model for regression
	void setWeight(int w) {	weightcb->setCurrentItem(w); }			//!< set weight
	void setWeightFunction(QString w);							//!< set weight function
	void setNumber(int nr) { numberle->setText(QString::number(nr)); }	//!< set number of points for regression function
	void setRange(double a, double b) {							//!< set range of regression function
		regioncb->setChecked(true);
		minle->setText(QString::number(a));
		maxle->setText(QString::number(b));
	}
	void setNegateRegion(bool b=true) 
		{ regioncb->setChecked(b); negate_regioncb->setChecked(b); }			//!< set and use negated region
	void showInfo(bool s=true) {	infocb->setChecked(s); }			//!< show info dialog
	void showResiduals(bool s=true) { rescb->setChecked(s); }		//!< show residuals instead of function
	QString Result() { return result; }					//!< get result of regression
	int Apply() { return apply_clicked(); }
private:
	QString result;
	KComboBox *modelcb, *weightcb;
	QCheckBox *infocb, *regioncb, *negate_regioncb, *rescb;
	KLineEdit *regionminle, *regionmaxle, *numberle, *minle, *maxle, *weightle;
private slots:
	void weightChanged();
	void saveSettings();
	int apply_clicked();
};

#endif // REGRESSIONLISTDIALOG_H
