//LabPlot : ExplorerDialog.h

#ifndef EXPLORERDIALOG_H
#define EXPLORERDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>
#include "Worksheet.h"
#include "Dialog.h"
#include "ExplorerListView.h"

// item for explorer list
class ExplorerItem
{
public:
	ExplorerItem(Worksheet* ws=0, Spreadsheet* ss=0, Plot* plot=0, Graph* graph=0);
	Worksheet* getWorksheet() { return ws; }
	Spreadsheet* getSpreadsheet() { return ss; }
	Plot* getPlot() { return plot; }
	Graph* getGraph() { return graph; }
private:
	Worksheet *ws;
	Spreadsheet *ss;
	Plot *plot;
	Graph *graph;
};

class ExplorerDialog: public Dialog
{
	Q_OBJECT
public:
	ExplorerDialog(MainWin *mw, const char *name);
	void updateDialog() { updateList(); }
private:
	ExplorerItem *list;
	ExplorerListView *lv;
	QPopupMenu *menu;
	int dragitem, dropitem;
private slots:
	void updateList();
	void rmouse(QListViewItem *item, const QPoint & point, int );
	void pressEvent( QListViewItem * );
	void releaseEvent( QMouseEvent * );
	void deleteItem();
	void cloneItem();
	void copyItem(bool remove=false);
	void moveItem();
	void newSpreadsheet() { mw->newSpreadsheet(); updateList(); }
	void newWorksheet() { mw->newWorksheet(); updateList(); }
};


#endif //EXPLORERDIALOG_H
