//LabPlot : PeakListDialog.cc

#include "PeakListDialog.h"
#include "source.h"
#include "defs.h"

using namespace std;

PeakListDialog::PeakListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	setCaption(i18n("Peak Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Peaks" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Threshold (y range) :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" dy = "),hb);
	thresholdle = new KLineEdit(config->readEntry("Threshold","0.5"),hb);
	thresholdle->setValidator(new QDoubleValidator(thresholdle));

	new QLabel(i18n(" Accuracy (x range) :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(QString(" x index = "),hb);
	accuni = new KIntNumInput(config->readNumEntry("Accuracy",3),hb);
	accuni->setRange(1,INF,1,false);

	hb = new QHBox(tab1);
	negativecb = new QCheckBox(i18n("negative peaks "),hb);
	negativecb->setChecked(config->readBoolEntry("NegativePeaks",false));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PeakListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Peaks" );

	config->writeEntry("Threshold",thresholdle->text());
	config->writeEntry("Accuracy",accuni->value());
	config->writeEntry("NegativePeaks",negativecb->isChecked());
}

int PeakListDialog::apply_clicked() {
	double threshold = thresholdle->text().toDouble();
	double accuracy = accuni->value();

	if(s) {
		//TODO
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
		return 0;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getType(item);

	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		// do it
		double xmin=0, xmax=1, ymin=0, ymax=1;
		int nr_points=0;
		for (int i = 0;i<nx;i++) {
			bool peak_found=false;
			double x = 0;
			double y = 0;

			for (int j=1;j<accuracy;j++) {
				if(negativecb->isChecked()) {
					if ((a[i].Y() < a[i-j].Y()-threshold || a[i].Y() < a[i+j].Y()-threshold )
						&& a[i].Y() < a[i-1].Y() && a[i].Y() < a[i+1].Y())
							peak_found=true;
				}
				else {
					if ((a[i].Y() > a[i-j].Y()+threshold || a[i].Y() > a[i+j].Y()+threshold )
						&& a[i].Y()>a[i-1].Y() && a[i].Y()>a[i+1].Y())
							peak_found=true;
				}
			}

			if(peak_found) {
				x = a[i].X();
				y = a[i].Y();
				nr_points++;
				kdDebug()<<"peak found ! @ "<<x<<'/'<<y<<endl;

				// new ranges
				if (nr_points==1) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}

				ptr[nr_points-1].setPoint(x,y);
			}
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("peaks (")+QString::number(nr_points)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nr_points);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point3D *a = g->Data();

		// do it
		double xmin=0, xmax=1, ymin=0, ymax=1;
		int nr_points=0;
		for (int i = 0;i<nx;i++) {
			bool peak_found=false;
			double x = 0;
			double y = 0;

			for (int j=1;j<accuracy;j++) {
				if(negativecb->isChecked()) {
					if ((a[i].Y() < a[i-j].Y()-threshold || a[i].Y() < a[i+j].Y()-threshold )
						&& a[i].Y() < a[i-1].Y() && a[i].Y() < a[i+1].Y())
							peak_found=true;
				}
				else {
					if ((a[i].Y() > a[i-j].Y()+threshold || a[i].Y() > a[i+j].Y()+threshold )
						&& a[i].Y()>a[i-1].Y() && a[i].Y()>a[i+1].Y())
							peak_found=true;
				}
			}

			if(peak_found) {
				x = a[i].X();
				y = a[i].Y();
				nr_points++;
				kdDebug()<<"peak found ! @ "<<x<<'/'<<y<<endl;

				// new ranges
				if (nr_points==1) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}

				ptr[nr_points-1].setPoint(x,y);
			}
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("peaks (")+QString::number(nr_points)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nr_points);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point4D *a = g->Data();

		// do it
		double xmin=0, xmax=1, ymin=0, ymax=1;
		int nr_points=0;
		for (int i = 0;i<nx;i++) {
			bool peak_found=false;
			double x = 0;
			double y = 0;

			for (int j=1;j<accuracy;j++) {
				if(negativecb->isChecked()) {
					if ((a[i].Y() < a[i-j].Y()-threshold || a[i].Y() < a[i+j].Y()-threshold )
						&& a[i].Y() < a[i-1].Y() && a[i].Y() < a[i+1].Y())
							peak_found=true;
				}
				else {
					if ((a[i].Y() > a[i-j].Y()+threshold || a[i].Y() > a[i+j].Y()+threshold )
						&& a[i].Y()>a[i-1].Y() && a[i].Y()>a[i+1].Y())
							peak_found=true;
				}
			}

			if(peak_found) {
				x = a[i].X();
				y = a[i].Y();
				nr_points++;
				kdDebug()<<"peak found ! @ "<<x<<'/'<<y<<endl;

				if (nr_points==1) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}

				ptr[nr_points-1].setPoint(x,y);
			}
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("peaks (")+QString::number(nr_points)+i18n(") of ")+g->getLabel()->simpleTitle());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nr_points);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPHM) {		// PSURFACE and P3D
		// TODO
		KMessageBox::error(this,i18n("Sorry. This function is not yet implemented!"));
	}

	updateList();

	return 0;
}
