/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tsetname.c,v 1.0 1999/07/21 19:00:19 jsquyres Exp $
 *
 *	Function:	- set datatype name
 *	Accepts:	- datatype
 *			- datatype name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Type_set_name(type, name)

MPI_Datatype		type;
char			*name;

{
	lam_initerr_m();
	lam_setfunc_m(BLKMPITSETNAME);
/*
 * Check the arguments.
 */
	if (type == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSETNAME, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (name == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITSETNAME, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	strncpy(type->dt_name, name, MPI_MAX_OBJECT_NAME);
	type->dt_name[MPI_MAX_OBJECT_NAME - 1] = 0;

	lam_resetfunc_m(BLKMPITSETNAME);
	return(MPI_SUCCESS);
}
