dnl -*- shell-script -*-

#
# $Id: lam_ansi_protos.m4,v 1.1 2000/10/17 12:05:17 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_ANSI_PROTOS,[
# Determine if compiler and options accepts ANSI prototypes.
AC_MSG_CHECKING([whether the C compiler ($CC $CFLAGS) accepts ANSI prototypes])
cat > conftest.c <<EOF
static double foo(double bar) { return(2.0*bar); }
int main(int argc, char **argv)
{ double x; x = foo(2.0); return(0); }
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_ansi_protos=yes
else
    lam_ac_ansi_protos=no
fi
AC_MSG_RESULT($lam_ac_ansi_protos)
/bin/rm -f conftest*])dnl

