dnl -*- shell-script -*-

# $Id: lam_check_cmsg_data.m4,v 1.3.2.1 2001/10/07 16:53:02 bbarrett Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_CHECK_IF_BSD44_CMSG_DATA_BROKEN,[

# The reason for this test is complicated.  It's mainly because some
# OS's (cough cough RH 7.1 cough cough) have an incorrect underlying
# socket.h file.  More to the point, the STREAMS macro for assinging
# data to a control message header (CMSG_DATA) is incorrect when using
# anything other than gcc.  #@$@#%$#@$%#!!!!!!  This causes Much
# Badness when using things like pgcc, KCC, IA64 compilers, etc.  But,
# of course, it always works like a champ with gcc.  @%$#@%$@#%$

# We have mailed in a patch to both RH (to fix their
# /usr/include/bits/socket.h) and to the Portland Group (so that they
# can override the system socket.h with their own [corrected]
# version).  It will take time to propogate these fixes out into the
# Real World, so we're providing a workaround for all broken
# instances.

# Save the current language (just in case)
AC_LANG_SAVE
AC_LANG_C

AC_MSG_CHECKING([if BSD44 CMSD_DATA macro is broken])

# Use a short test program
AC_TRY_RUN([#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <errno.h>
#include <stddef.h>
#include <sys/un.h>

typedef struct cmsgfd
{
  struct cmsghdr ctl;		/* control message header */
  int dummy;			/* space for file descriptor */
} cmsgfd_t;

/*
 * Global so that we can kill the child if the parent barfs
 */
pid_t child_pid = 0;


int sfh_send_fd(int stream, int fd);
int sfh_recv_fd(int stream);


int
main(int argc, char **argv)
{
  int fd[2];

  if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd)) {
    perror("pipe");
    exit(-1);
  }

  if ((child_pid = fork()) < 0) {
    perror("fork");
  } else if (child_pid > 0) {
    /* I am the parent... */
    if (sfh_send_fd(fd[0], 0)) {
      exit(-1);
    }
  } else {
    /* I am the child... */
    if (sfh_recv_fd(fd[1]) == -1) {
      exit(-1);
    }
  }

  return 0;
}


/*
 * Send a file descriptor using STREAMS.  Does it work?
 */
int
sfh_send_fd(int stream, int fd)
{
  struct iovec iov[1];
  struct msghdr msg;
  char buf[1];
  cmsgfd_t ctlfd;
  int r;
  int status;

  iov[0].iov_base = buf;
  iov[0].iov_len = 1;
  msg.msg_iov = iov;
  msg.msg_iovlen = 1;
  msg.msg_name = NULL;
  msg.msg_namelen = 0;
  msg.msg_control = (caddr_t) & ctlfd;
  msg.msg_controllen = (sizeof(cmsgfd_t));

  ctlfd.ctl.cmsg_level = SOL_SOCKET;
  ctlfd.ctl.cmsg_type = SCM_RIGHTS;
  ctlfd.ctl.cmsg_len = (sizeof(cmsgfd_t));
  *(int *) CMSG_DATA(&ctlfd.ctl) = fd;

  do {
    r = sendmsg(stream, &msg, 0);
    if (r == 1)
      break;
    else if (r < 0 && errno == EINTR)
      continue;
    else {
      /* Renice?  You must mean kill -9. */
      kill(child_pid, 9);
      waitpid(child_pid, &status, 0);
      return (-1);
    }
  } while (1);

  return (0);
}


/*
 * Receive a file descriptor using STREAMS.
 */
int
sfh_recv_fd(int stream)
{
  struct msghdr msg;
  struct iovec iov[1];
  char buf[1];
  cmsgfd_t ctlfd;
  int r;

  iov[0].iov_base = buf;
  iov[0].iov_len = 1;
  msg.msg_iov = iov;
  msg.msg_iovlen = 1;
  msg.msg_name = (caddr_t) 0;
  msg.msg_namelen = 0;
  msg.msg_control = (caddr_t) & ctlfd.ctl;
  msg.msg_controllen = (sizeof(cmsgfd_t));

  do {
    r = recvmsg(stream, &msg, 0);
    if (r == 1)
      break;
    else if (r < 0 && errno == EINTR)
      continue;
    else
      return (-1);
  } while (1);

  return (*(int *) CMSG_DATA(&ctlfd.ctl));
}], CMSG_BROKEN=0 MSG="no", CMSG_BROKEN=1 MSG="yes", CMSG_BROKEN=0 MSG="no")

# Save the results
AC_MSG_RESULT($MSG)
AC_DEFINE_UNQUOTED(LAM_CMSG_DATA_BROKEN, $CMSG_BROKEN)

# Restore
unset MSG CMSG_BROKEN
AC_LANG_RESTORE])dnl
