dnl -*- shell-script -*-

#
# $Id: lam_get_fortran_alignment_cache.m4,v 1.4.2.1 2001/11/09 20:53:13 brbarret Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_GET_FORTRAN_ALIGNMENT_CACHE,[
# Determine FORTRAN datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of FORTRAN $1,$2,[
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external ALIGN
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call ALIGN(w,x,y,z)
      end
EOF
if test -f conftest.h; then
    conftest="#include \"conftest.h\""
else
    conftest=""
fi
cat > conftest.c <<EOF
#include <stdio.h>
$conftest
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
echo configure:__oline__: $CC $CFLAGS -I. -c conftest.c >&5
$CC $CFLAGS -I. -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest1.c >&5
    echo configure:__oline__: here is conftest.h: >&5
    cat conftest.h >&5
else
    echo configure:__oline__: $F77 $FFLAGS conftestf.f conftest.o -o conftest  >&5
    $F77 $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	$2=`cat conftestval`
    else
	AC_MSG_WARN(error compiling/running conftest)
	echo configure:__oline__: here is the program that failed: >&5
	cat conftest1.f >&5
    fi
fi
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl
