/*                                                                                                            
 * Copyright (c) Members of the EGEE Collaboration. 2004.
 * See http://eu-egee.org/partners/ for details on the copyright holders.
 * For license conditions see the license file or
 * http://eu-egee.org/license.html
 */

/*
 *   Copyright (c) 2003 EU DataGrid        http://www.eu-datagrid.org/
 *
 *   $Id: pdl_lex.l 16418 2012-07-05 15:15:51Z msalle $
 *
 *   Copyright (c) 2003 by
 *      G.M. Venekamp <venekamp@nikhef.nl>
 *      NIKHEF Amsterdam, the Netherlands
 *
 *   This software is distributed under a BSD-style open source
 *   licence. For a complete description of the licence take a look
 *   at: http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 *
 */

/* Don't use yywrap functionality, this prevents missing symbols */
%option noyywrap

%{
#include <string.h>

#include "pdl.h"
#include "pdl_rule.h"
#include "pdl_yacc.h"
#include "pdl_policy.h"

/*static int no_valid_rule=0;*/

#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) \
    lcmaps_warning(PDL_ERROR, "Fatal parsing error: %s", (msg));
#endif
%}

ws           [\t ]+
nl           \n
term         [a-zA-Z_\.0-9/]+
label        ^[ \t]*[a-zA-Z_\.0-9/]+:
trans        "->"
comment      #[^\n]*\n
tokens       [\~=\|]
pvar         "path"
pdlstr       \"[^\"\n]*[\"\n]


%x path pathcom linecom mq
%%

{ws}         ;
{pvar}       { BEGIN path; return PVAR; }
<path>{tokens}  { return yytext[0]; }
<path>{ws}      ;
<path>{term}    { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
		      ((yylval.record)->string = strdup(yytext)) == NULL) {
                      lcmaps_warning(PDL_ERROR, "out of memory.");
                      return 0;
		  }
                  (yylval.record)->lineno = lineno;
                  return PATH;
                }
<path>\n        { ++lineno; BEGIN INITIAL; }
<path>{comment} { ++lineno; BEGIN INITIAL; }
{label}      { yytext[yyleng-1] = '\0';   /* remove trailing ':' */

               /*  Check if this policy rule is allowed or not. */
               if (lcmaps_allowed_policy_rule(yytext)) {
                 lcmaps_allow_rules(TRUE);
               } else {
                 /*  This label should not be added, however normal parsing
                  *  must continue.  */
                 lcmaps_allow_rules(FALSE);
               }
               if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
		   ((yylval.record)->string = strdup(yytext)) == NULL) {
                   lcmaps_warning(PDL_ERROR, "out of memory.");
                   return 0; 
	       }
               (yylval.record)->lineno = lineno;
               return LABEL;
             }
{term}       { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL ||
                   ((yylval.record)->string = strdup(yytext)) == NULL) {
                   lcmaps_warning(PDL_ERROR, "out of memory.");
                   return 0;
	       }
               (yylval.record)->lineno = lineno;
               return TERM;
             }
{nl}         { ++lineno;          }
{tokens}     { return yytext[0];  }
{trans}      { return TRANS;      }
{comment}    { ++lineno;	  }
{pdlstr}     { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL) {
	           lcmaps_warning(PDL_ERROR, "out of memory.");
		   return 0;
	       }
               if (yytext[yyleng-2] == '\\') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
	               lcmaps_warning(PDL_ERROR, "out of memory.");
		       return 0;
	           }
		   (yylval.record)->string[yyleng-2] = '\0';
		   (yylval.record)->string[yyleng-3] = '\"';
		   (yylval.record)->lineno = lineno;
		   yyless(yyleng-1);  /*  make the next string start with "  */
		   BEGIN mq;
		   return STRING;
	       } else if (yytext[yyleng-1] == '\"') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
	               lcmaps_warning(PDL_ERROR, "out of memory.");
		       return 0;
	           }
		   (yylval.record)->string[yyleng-2] = '\0';
                   (yylval.record)->lineno = lineno;
	    	   return STRING;
               } else {
		   lcmaps_warning(PDL_ERROR, "Unbalanced quotes.");
                   return 0;
	       }
             }
<mq>{pdlstr} { if ((yylval.record = (record_t*)malloc(sizeof(record_t))) == NULL) {
		   lcmaps_warning(PDL_ERROR, "out of memory.");
                   return 0;
	       }
               if (yytext[yyleng-2] == '\\') {
                   if (((yylval.record)->string = strdup(yytext+1)) == NULL) {
		       lcmaps_warning(PDL_ERROR, "out of memory.");
                       return 0;
	           }
                   (yylval.record)->string[yyleng-2] = '\0';
                   (yylval.record)->string[yyleng-3] = '\"';
                   (yylval.record)->lineno = lineno;
                   yyless(yyleng-1);  /*  make the next string start with "  */
                   BEGIN INITIAL;
                   return STRING;
               } else {
                   lcmaps_warning(PDL_ERROR, "Unbalanced quotes.");
                   return 0;
               }
             }
.            { lcmaps_warning(PDL_WARNING, "unrecognized token '%c'.", yytext[0]);
               return yytext[0];
             }
%%
