#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "diawxxt.h"
/*
	Strips all blank and line feed at the end of a string
  	newstr and str may be the same string.
	Return the number of bytes striped at the end.
*/
int str_strip (
	const char *str,	// String to truncate
	char *newstr)		// result
{
	int ret = 0;
	int len = strlen(str);
	char *pt = newstr + len-1;
	strcpy (newstr,str);
	while (len > 0 && isspace(*pt)){
		*pt-- = '\0';
		len --;
		ret ++;
	}
	return (ret);
}
/*
	Advance a single char in a string unless this is the end of the string
*/
char *str_skipone (const char *s)
{
	if (*s != '\0') s++;
	return (char*)s;
}
/*
	Strip all blank (white space) at the end of a line.
	blanks are identified by isspace().
	Return a pointer to the last character +1 (right on the '\0', the
	new one).

	ATTENTION: To help cooperate with some DOS editor, ^Z is processed
	as a white space.
*/

char *strip_end(char *str)
{
	int len = strlen(str);
	for (str += len - 1
		; len > 0 && (isspace(*str) || *str == 26)
		; len--, str--) *str = '\0';
	return str+1;
}
/*
	Skip the white space in a string. Stop at the end or at the first
	non white space.
*/
char *str_skip(const char *str)
{
	while (isspace(*str)) str++;
	return (char*)str;
}
/*
	Skip the digit space in a string. Stop at the end or at the first
	non digit character.
*/
char *str_skipdig(const char *str)
{
	while (isdigit(*str)) str++;
	return (char*)str;
}

/*
	Check if a string is made of digits only.
	Return != 0 if yes.
*/
int str_checkdig(const char *str)
{
	const char *endstr = str_skipdig(str);
	return *endstr == '\0' && endstr > str;
}

/*
	Decompose a record in separate field (like /etc/passwd)
	Return the number of field written in words[]
*/
int str_splitline (
	const char *line,	// Line to split
	char delim,			// Field delimiter
	char words[][100],	// Will contain the separated words
	int maxwords)
{
	int noword = 0;
	char *dst = words[0];
	int i;
	int len = 0;
	for (i=0; i<maxwords; i++) words[i][0] = '\0';
	while (*line != '\0' && *line != '\n'){
		if (*line == delim){
			line++;
			*dst = '\0';
			noword++;
			len = 0;
			if (noword == maxwords) break;
			dst = words[noword];
		}else if (len == 99){
			// Too long, the field will be truncated
			// This probably mean the input file was corrupted anyway.
			line++;
		}else{
			*dst++ = *line++;
			len++;
		}
	}
	*dst = '\0';
	return noword+1;
}

