#pragma interface
#ifndef QUOTA_H
#define QUOTA_H

class PRIVILEGE;

class QUOTA_SPEC: public ARRAY_OBJ{
public:
	SSTRING name;	// User or group
	int soft_maxk;	// Soft maximum. The user may outdo this for some
					// grace period
					// Maximum allocated Kbytes to this user/group
					// While the kernel works in blocks, here we work
					// in K and linuxconf does the translation
					// when updating the quota.user or quota.group file
	int hard_maxk;	// Absolute maximum
	int soft_maxf;	// Soft maximum files.
	int hard_maxf;	// Absolute maximum
	TIMESTR grace_k;	// Grace period during which the user may outdo
						// the soft_maxk
	TIMESTR grace_f;	// Same for files
	/*~PROTOBEG~ QUOTA_SPEC */
public:
	QUOTA_SPEC (const QUOTA_SPEC *s);
	QUOTA_SPEC (const char *val);
	QUOTA_SPEC (void);
private:
	void init (void);
public:
	bool isdiff (const QUOTA_SPEC&s)const;
	void reset (void);
	void setfrom (const QUOTA_SPEC *s);
	void setfrom (const char *val);
	void setupdia (DIALOG&dia);
	void write (CONFDB&conf,
		 const char *key,
		 const char *device);
	/*~PROTOEND~ QUOTA_SPEC */
};

class QUOTA_SPECS: public ARRAY{
	/*~PROTOBEG~ QUOTA_SPECS */
public:
	QUOTA_SPECS (CONFDB&conf,
		 const char *key,
		 const char *device);
	QUOTA_SPECS (void);
	QUOTA_SPEC *getitem (const char *name)const;
	QUOTA_SPEC *getitem (int no)const;
	void write (CONFDB&conf,
		 const char *key,
		 const char *device);
	/*~PROTOEND~ QUOTA_SPECS */
};

// Quota specification for a device/partition
class QUOTA_DEV: public ARRAY_OBJ{
public:
	SSTRING device;
	SSTRING realdev;		// Convert the device from LABEL= to a /dev/ device
	QUOTA_SPEC  userdef;		// Default for users without a specific
								// quota and without a group default.
	QUOTA_SPECS userdef_g;		// Defaults for members of a group
	QUOTA_SPECS users;			// Specific per user quota

	QUOTA_SPEC  groupdef;		// Default for groups without a specific
								// quota and without a group default.
	QUOTA_SPECS groups;			// Group quota
	/*~PROTOBEG~ QUOTA_DEV */
public:
	QUOTA_DEV (CONFDB&conf, const char *device);
	void applyall (void);
	void applyone (struct passwd *p);
	void delgroupspec (const char *name);
	void deluserdef_gspec (const char *name);
	void deluserspec (const char *name);
	void geteffgroupspec (const char *group,
		 QUOTA_SPEC&eff);
	void geteffuserspec (const char *name,
		 const char *group,
		 QUOTA_SPEC&eff);
	QUOTA_SPEC *getgroupspec (const char *name);
	QUOTA_SPEC *getuserdef_gspec (const char *name);
	QUOTA_SPEC *getuserspec (const char *name);
	int setrealdevice (void);
	void write (CONFDB&conf);
	/*~PROTOEND~ QUOTA_DEV */
};

class QUOTA_DEVS: public ARRAY{
	/*~PROTOBEG~ QUOTA_DEVS */
public:
	QUOTA_DEV *getitem (int no)const;
	/*~PROTOEND~ QUOTA_DEVS */
};

class QUOTACTL{
friend class QUOTA_EDIT;
	CONFDB *conf;
	QUOTA_DEVS devs;
	/*~PROTOBEG~ QUOTACTL */
public:
	QUOTACTL (void);
	void applyall (const char *dev);
	void applyall (void);
	int applyone (const char *user);
	void editdef (void);
	QUOTA_DEV *getdev (const char *device);
	int write (PRIVILEGE *priv);
	~QUOTACTL (void);
	/*~PROTOEND~ QUOTACTL */
};

class DIALOG;

enum QUOTA_TYPE{
	QUOTA_USER,QUOTA_GROUP,QUOTA_USERDEF_G
};

class QUOTA_EDIT{
	QUOTA_TYPE type;	// Edit a user or a group or a group defaults
	SSTRING name;
	SSTRING group;
	QUOTA_SPECS specs;	// effective specs of the current user or group
	bool is_new;		// We are editing a new user/group
	/*~PROTOBEG~ QUOTA_EDIT */
public:
	QUOTA_EDIT (const char *_name, QUOTA_TYPE type);
	int deluser (PRIVILEGE *priv);
private:
	void geteffspec (QUOTA_DEV *d, QUOTA_SPEC&eff);
	QUOTA_SPEC *getspec (QUOTA_DEV *d);
public:
	int save (PRIVILEGE *priv);
	void setgroup (const char *grp);
	void setname (const char *_name);
	void setupdia (DIALOG&dia, const char *maintitle);
	~QUOTA_EDIT (void);
	/*~PROTOEND~ QUOTA_EDIT */
};

#endif

