/*
 Heartbeat configurator v1.6.2
 by Alexandre Augustus Falcao

 v1.0       - first version. Jun 8th, 2000
 v1.1-1.6.1 - versions with no changelogs here
 v1.6.2     - now heartbeatconf runs again directly from comand line
              (Linuxconf's API change introduced this bug).
              by Daniel Mealha Cabrita (dancab@conectiva.com)
              Nov 30th, 2000
*/


#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include <misc.h>
#include <fviews.h>
#include <subsys.h>
#include "heartbeatconf.h"
#include "heartbeatconf.m"

#include "nodes.h"
#include "authkeys.h"
#include "devices.h"
#include "misc.h"

static LINUXCONF_SUBSYS sub("heartbeatconf", P_MSG_U(HEARTBEATDESCRIPTION, "Setup the heartbeat system"));

MODULE_DEFINE_VERSION(heartbeatconf);

PUBLIC MODULE_heartbeatconf::MODULE_heartbeatconf()
                : LINUXCONF_MODULE("heartbeatconf")
{
    linuxconf_loadmsg ("heartbeatconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_heartbeatconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
                keymenu = MSG_U(M_heartbeatconf,"Heartbeat Configuration");
		dia.new_menuitem ("heartbeatconf","",keymenu);
	}
}

PUBLIC int MODULE_heartbeatconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
                    edit_heartbeatconf();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}

PUBLIC void edit_heartbeatconf()
{
    DIALOG_MENU dia;
    dia.new_menuitem("", MSG_U(M_NODES, "Nodes and Services"));
    dia.new_menuitem("", MSG_U(M_AUTHKEYS, "Authentication Keys"));
    dia.new_menuitem("", MSG_U(M_DEVICE, "Device Configuration"));
    dia.new_menuitem("", MSG_U(M_MISC, "Misc Configuration"));
    int opt = 0;
    while(1)
    {
        MENU_STATUS menu = dia.editmenu(MSG_U(T_MAINTITLE, "Heartbeat Configuration"), MSG_U(I_MAINDESC, "This module configures\nheartbeat, a basic heartbeat\nsubsystem for Linux-HA."), help_heartbeat, opt, 0);
        if(menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if(opt == 0)
            edit_nodes();
        else if(opt == 1)
            edit_authkeys();
        else if(opt == 2)
            edit_devices();
        else if(opt == 3)
            edit_misc();
    }
}


PUBLIC int MODULE_heartbeatconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"heartbeatconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain heartbeatconf usage\n"
		 "\n"
		 "    heartbeatconf --option ...\n")
		);
}

PUBLIC void MODULE_heartbeatconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_heartbeatconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"heartbeatconf")==0){
		ret = -1;
		if (argc == 1){
                    edit_heartbeatconf();
                    // ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_heartbeatconf heartbeatconf;

