#ifndef managerpm_h
#define managerpm_h
#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
class MODULE_managerpm: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_managerpm */
public:
	MODULE_managerpm (void);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[], bool);
	void setmenu (DIALOG&dia,
		 MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
    /*~PROTOEND~ MODULE_managerpm */
};

struct VERSION_ITEM {
	int num;
	const char *suffix;
};

struct VERSION_ITEMS{
	char str[100];
	int nb;
	VERSION_ITEM tb[10];
};

class RPM_OPTIONS {
public:
	char nodep;
	char force;
	char oldrev;
	char replace;
	char noscripts;
	char notrigger;
	char excludedocs;
	char test;
	/*~PROTOBEG~ RPM_OPTIONS */
public:
	RPM_OPTIONS (void);
	void addargs (SSTRING&args)const;
	/*~PROTOEND~ RPM_OPTIONS */
};

class LOOKUP;
class PACKAGES;
class PACKAGE;

class STRENTRY: public ARRAY_OBJ{
public:
	const char *val;
	LOOKUP *provides;
	LOOKUP *requires;
	STRENTRY *next;
	/*~PROTOBEG~ STRENTRY */
public:
	STRENTRY (const char *s);
	void addprovide (PACKAGE *p,
		 const char *oper,
		 const char *ver);
	void addrequire (PACKAGE *p,
		 const char *oper,
		 const char *ver);
	void forgetpkg (PACKAGE *pkg);
	bool testconflicts (const char *name,
		 PACKAGES&conflicts);
	bool testinstall (PACKAGES&needs);
	bool testuninstall (PACKAGES&needs);
	~STRENTRY (void);
	/*~PROTOEND~ STRENTRY */
};

class STRENTRIES: public ARRAY{
	/*~PROTOBEG~ STRENTRIES */
public:
	void forgetpkg (PACKAGE *pkg);
	STRENTRY *getitem (int no)const;
	/*~PROTOEND~ STRENTRIES */
};

class CONFLICTS;

class PACKAGE: public ARRAY_OBJ{
public:
	SSTRING name;
	SSTRING version;
	VERSION_ITEMS v;	// Parsed version
	SSTRING release;
	VERSION_ITEM relnum;	// Parsed release
	SSTRING group;
	SSTRING vendor;
	SSTRING distribution;
	SSTRING fullname;
	SSTRING summary;
	STRENTRIES provides;
	STRENTRIES requires;
	bool installed;		// Is this an installed package or not
	// Various flags for the operation
	char selected;		// Was this package selected in a dialog
	bool needed;		// This uninstalled package is needed
						// (required) by another package we are trying
						// to install
	/*~PROTOBEG~ PACKAGE */
public:
	PACKAGE (const char *_name,
		 const char *_version,
		 const char *_release,
		 const char *_group,
		 const char *_vendor,
		 const char *_distribution,
		 const char *_summary);
	void addprovide (const char *pro);
	void addrequire (const char *req);
	int cmp (const PACKAGE *p);
	int install (void);
	bool is_installed (void)const;
	bool is_needed (void)const;
	bool is_selected (void)const;
	void showfiles (void);
	void showinfo (void);
	bool testinstall (PACKAGES&needs,
		 SSTRINGS&missing,
		 CONFLICTS&conflicts);
	bool testuninstall (PACKAGES&needs);
	int uninstall (void);
	~PACKAGE (void);
	/*~PROTOEND~ PACKAGE */
};

class PARSE_STATE;

class PACKAGES: public ARRAY{
	/*~PROTOBEG~ PACKAGES */
public:
	bool any_selected (void);
	PACKAGE *getitem (int no)const;
	int install (void);
	int load (const char *rpmarg,
		 bool is_installed,
		 int nbpkg,
		 const char *title);
	int load (const char *rpmarg,
		 bool is_installed,
		 int nbpkg,
		 const char *title,
		 SSTRINGS *tberr);
	int loadfromdir (const char *dir, const char *wild);
private:
	int loadfromdir_real (const char *dir,
		 const char *wild,
		 SSTRINGS&tb);
public:
	int loadfrompath (const char *path);
	int loadinstall (void);
	PACKAGE *locate (const char *name)const;
private:
	void parse (PARSE_STATE&st, char *buf);
public:
	void remove_dups (void);
	void resetneeded (void);
	int select (const char *pattern, PACKAGES&sels);
	void selectall (void);
	void sort (void);
	bool testinstall (bool&nodeps, bool&replacefiles);
	bool testuninstall (bool&nodeps);
	int uninstall (void);
	void unselectall (void);
	/*~PROTOEND~ PACKAGES */
};

#include "managerpm.p"

#endif
