#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "mgettyconf.h"
#include "mgettyconf.m"

MODULE_DEFINE_VERSION(mgettyconf);

PUBLIC MODULE_mgetty::MODULE_mgetty()
	: LINUXCONF_MODULE("mgettyconf")
{
	linuxconf_loadmsg ("mgettyconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_mgetty::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_mgetty,"Serial port setup (mgetty)");
		dia.new_menuitem ("mgetty","",keymenu);
	}
}

PUBLIC int MODULE_mgetty::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			mgetty_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_mgetty::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"mgetty")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module mgetty\n"
		 "\n"
		 "    Without argument, starts the main menu\n")
		);
}

PUBLIC void MODULE_mgetty::usage(SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_mgetty::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"mgetty")==0){
		ret = -1;
		if (argc == 1){
			mgetty_edit();
			ret = 0;
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_mgetty mgetty;

