/*
	This API allows module to request information about hardware device,
	perform probes and so on. Several module may supply such API.
*/
#ifndef DEVCONV_API_H
#define DEVCONF_API_H

#include <module_api.h>
#include <module_apis/devconf_apidef.h>
static const char DEVCONF_API_KEY[]="devconf";
static const int  DEVCONF_API_REV=1;

inline int devconf_apis_init(
	const char *client,
	DEVCONF_API *tb[])
{
	return module_get_apis (DEVCONF_API_KEY,DEVCONF_API_REV
		,client,(void*[])tb);
}

inline void devconf_apis_end(DEVCONF_API *apis[], int nbapis)
{
	module_release_apis (DEVCONF_API_KEY,(void*[])apis,nbapis);
}

inline bool devconf_api_available(const char *client)
{
	return module_api_available (DEVCONF_API_KEY,DEVCONF_API_REV,client);
}


#endif



