#include <string.h>
#include <errno.h>
#include <limits.h>
#include <context.h>
#include <netconf.h>
#include "../../main/main.h"
#include "netadm.h"
#include "netadm.m"
#include "../paths.h"
#include "internal.h"

static NETADM_HELP_FILE help_tree ("tree");

/*
	Get the list of administration trees available
*/
int tree_getlist (SSTRINGS &tb)
{
	return dir_getlist (ETC_LINUXCONF_ADMTREES,tb);
}

void tree_editone (const char *tree)
{
	char path[PATH_MAX];
	sprintf (path,"%s/%s",ETC_LINUXCONF_ADMTREES,tree);
	if (file_type(path)!=1){
		xconf_error (MSG_U(E_NOTREE,"Administration tree %s does not exist")
			,tree);
	}else{
		LINUXCONF_CONTEXT tree_context (path);
		char title[100];
		snprintf (title,sizeof(title)-1,"[%s] ",tree);
		tree_context.settitle (title);
		ui_context.set(tree_context);
		linuxconf_main(1);
	}
}

static void ft (void *p)
{
	const char *tree = (const char *)p;
	tree_editone (tree);
}

static int tree_add ()
{
	int ret = -1;
	SSTRING name;
	DIALOG dia;
	dia.newf_str (MSG_U(F_TREENAME,"Tree name"),name);
	dia.last_noempty();
	char buf[1000];
	snprintf (buf,sizeof(buf)-1,MSG_U(I_ADDTREE
		,"You must enter a name for this new administration tree.\n"
		 "This will correspond to a new sub-directory in\n"
		 "%s")
		,ETC_LINUXCONF_ADMTREES);
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_ADDTREE,"New administration tree")
			,buf
			,help_tree);
		if (code!=MENU_ACCEPT){
			break;
		}else{
			if (name.strchr(' ')!=NULL){
				xconf_error (MSG_U(E_NOSPACE,"No space allowed in name"));
			}else{
				char path[PATH_MAX];
				sprintf (path,"%s/%s",ETC_LINUXCONF_ADMTREES,name.get());
				file_mkdir (ETC_LINUXCONF,"root","root",0700);
				file_mkdir (ETC_LINUXCONF_ADMTREES,"root","root",0700);
				if (file_mkdir (path,"root","root",0700)==-1){
					xconf_error (MSG_U(E_CREATEDIR
						,"Can't create directory %s\n"
						 "(%s)")
						,path,strerror(errno));
				}else{
					netconf_system_if ("populate.sh",name.get());
					ret = 0;
					break;
				}
			}
		}
	}	
	return ret;
}

void tree_edit ()
{
	DIALOG *dia = NULL;
	int nof = 0;
	SSTRINGS trees;
	while (1){
		if (dia == NULL){
			dia = new DIALOG;
			trees.remove_all();
			tree_getlist (trees);
			for (int i=0; i<trees.getnb(); i++){
				dia->new_menuitem ("",trees.getitem(i)->get());
			}
		}
		MENU_STATUS code = dia->editmenu(
			MSG_U(T_ADMINTREES,"Administration trees")
			,MSG_U(I_ADMINTREES
				,"Here are the various administration trees\n"
				 "already defined. You can add new one.\n"
				 "An administration tree is a virtual workstation\n"
				 "you can manage from here. The various configuration\n"
				 "file may be distributed to other workstations/servers\n"
				 "on the network.")
			,help_tree
			,nof,MENUBUT_ADD);
		bool must_delete = false;
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			if (tree_add()!=-1) must_delete = true;
		}else if (nof >=0 && nof < trees.getnb()){
			const char *tree = trees.getitem(nof)->get();
			uithread (ft,(void*)tree);
		}
		if (must_delete){
			delete dia;
			dia = NULL;
		}
	}
	delete dia;
}

