// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration parameters that to do address masquerading
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::ldaplookuptout_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// ldap_lookup_timeout
	st = data.getvarvariable(V_LDAP_LOOKUP_TIMEOUT);
	dia.newf_str (MSG_U(F_LDAPLKPTOUT,"Ldap lookup timeout"),*st);

	// ldap_search_base
	st = data.getvarvariable(V_LDAP_SEARCH_BASE);
	dia.newf_str(MSG_U(F_LDAPSEARCHBASE,"Ldap search base"),*st);
	
	// ldap_server_host
	st = data.getvarvariable(V_LDAP_SERVER_HOST);
	dia.newf_str(MSG_U(F_LDAPSRVHOST,"Ldap server host"),*st);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_LDAPLOOKUPTOUT,"Configure LDAP lookups")
			,MSG_U(I_LDAPLOOKUPTOUT,"Here you can configure options that control LDAP lookups")
			,help_postfix_ldaplookuptout
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// ldap_lookup_timeout
			if ( is_caracter(data.getvarvariable(V_LDAP_LOOKUP_TIMEOUT)->get() ) ){
				nof = 0;
				xconf_notice(MSG_U(E_ONLYDIGIT,"Only digit are accept!"));
				continue;
			}

			// ldap_search_base
			if ( is_caracter(data.getvarvariable(V_LDAP_SEARCH_BASE)->get() )){
				nof = 1;
				xconf_notice(MSG_R(E_ONLYDIGIT));
				continue;
			}

			// ldap_server_host
			if ( is_caracter(data.getvarvariable(V_LDAP_SERVER_HOST)->get() )){
				nof = 2;
				xconf_notice(MSG_R(E_ONLYDIGIT));
				continue;
			}
			
			ret = 1;
			break;
		}if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_LDAP_LOOKUP_TIMEOUT,
						V_LDAP_SEARCH_BASE,
						V_LDAP_SERVER_HOST,
						-1
				};
				data.setdefaultvarvalues(values);
				dia.reload();
			}
		}
	}
	return ret;
}
