/* these are the files managed through linuxconf's CONFIG_FILE object */

#include "printer.h"
#include "printer.m"
#include <subsys.h>
#include <translat.h>

LINUXCONF_SUBSYS sub ("lpd",P_MSG_U(M_LPDSYS,"Print spooler"));

/* printcap - r/w */
CONFIG_FILE cf_printcapfile("/etc/printcap", help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, "lpd");
/* printerdb - read only */
CONFIG_FILE cf_printerdbfile("/usr/lib/rhs/rhs-printfilters/printerdb", help_nil, CONFIGF_NOARCH);
/* master-filter, smbprint, ncpprint - read only */
CONFIG_FILE cf_masterfilterfile("/usr/lib/rhs/rhs-printfilters/master-filter", help_nil, CONFIGF_NOARCH);
CONFIG_FILE cf_smbprint("/usr/lib/rhs/rhs-printfilters/smbprint", help_nil, CONFIGF_NOARCH);
CONFIG_FILE cf_ncpprint("/usr/lib/rhs/rhs-printfilters/ncpprint", help_nil, CONFIGF_NOARCH);
/* hosts.lpd - r/w */
CONFIG_FILE cf_hostslpdfile("/etc/hosts.lpd", help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, "lpd");
/* this is LPRng specific */
CONFIG_FILE cf_lpdconf("/etc/lpd.conf", help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, "lpd");

HELP_FILE my_allowedhosts_helpfile("printer", "allowedhosts");
HELP_FILE my_edit_helpfile("printer", "edit");
HELP_FILE my_main_helpfile("printer", "printer");
HELP_FILE my_properties_helpfile("printer", "properties");
HELP_FILE my_queuemgrmain_helpfile("printer", "queuemgrmain");
HELP_FILE my_queuemsgmenu_helpfile("printer", "queuemsgmenu");

