
/* here are the routines which deal with the printers' config files,
 the variables which deal with the /var/spool/lpd/my_printer/ files
 are here (the printcap-related ones are in printer_common_data.h) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <subsys.h>

#include "deez_parser.h"
#include "printer_printcap.h"
#include "printer_common_data.h"
#include "printer_cfile.h"
#include "printer_fi.h"
#include "printer.m"

#include "printer_smbncp-specific.h"

/* these are my_parms, first entry is the filename */
char ps_cfg_tag[]="postscript.cfg\0GSDEVICE=\0RESOLUTION=\0COLOR=\0PAPERSIZE=\0EXTRA_GS_OPTIONS=\0REVERSE_ORDER=\0PS_SEND_EOF=\0NUP=\0RTLFTMAR=\0TOPBOTMAR=\0\0";
char to_cfg_tag[]="textonly.cfg\0TEXTONLYOPTIONS=\0CRLFTRANS=\0TEXT_SEND_EOF=\0\0";
char ge_cfg_tag[]="general.cfg\0DESIRED_TO=\0PAPERSIZE=\0PRINTER_TYPE=\0ASCII_TO_PS=\0\0";

/* these properties don't store all printers simultaneously (unlike printcap ones),
   they only store for the currently-edited printer */
struct t_rh_array ps_cfg[10];
struct t_rh_array to_cfg[3];
struct t_rh_array ge_cfg[4];

/* variables for editfilter field of editprinter window */
/* they're meant to be accessed only by
 editfilter_window(int which_printer, DIALOG &filterwindow)
 editprinter_window(int which_printer)
 (which are one window now)
 */
char f_printername[TYPICAL_STRING_SIZE];

/* GUI variables */
char f_filterdescription[BIG_STRING_SIZE];
SSTRING f_resolution;
SSTRING f_papersize;
SSTRING f_colordepth;
char f_sendeof;
char f_correctcrlf;
char f_fastascii;
SSTRING f_printedpages;
int f_horizmargins;
int f_vertmargins;
char f_extragsopt[TYPICAL_STRING_SIZE];


/* writes 'printer.lp_something This is my filter description' to global linuxconf settings file */
/* this is necessary to know which printer was selected by user since now there are new entries
 in printerdb file which points to the same drivername, because this sometimes the
 wrong printer is showed after selection just because it uses the same GS driver */
void write_filter_description(int which_printer, const char *given_desc)
{
    char mtemp[TYPICAL_STRING_SIZE];
    char *zerothis;

    strcpy(mtemp, my_printcap[which_printer].printer_name);
    if((zerothis=strchr(mtemp, '|')))
        *zerothis=0;
    strcat(mtemp, "_filterdesc");
    linuxconf_replace ("printer", mtemp, given_desc);
    linuxconf_save();
}

/* reads filter description from global linuxconf settings file */
const char *read_filter_description(int which_printer)
{
    char mtemp[TYPICAL_STRING_SIZE];
    char *zerothis;

    strcpy(mtemp, my_printcap[which_printer].printer_name);
    if((zerothis=strchr(mtemp, '|')))
        *zerothis=0;
    strcat(mtemp, "_filterdesc");
    return(linuxconf_getval("printer", mtemp));
}

void remove_filter_description(int which_printer)
{
    char mtemp[TYPICAL_STRING_SIZE];
    char *zerothis;

    strcpy(mtemp, my_printcap[which_printer].printer_name);
    if((zerothis=strchr(mtemp, '|')))
        *zerothis=0;
    strcat(mtemp, "_filterdesc");
    linuxconf_removeall ("printer", mtemp);
    linuxconf_save();
}

/* creates a thing like:
 ##PRINTTOOL3## LOCAL uniprint NAxNA legal {} U_EpsonStylusColor stc_h {}
 from the currently selected printer (loaded to variables) */
void create_commented_printcap_config(char *output_string)
{
    char my_startentry[TYPICAL_STRING_SIZE];
    char my_color[TYPICAL_STRING_SIZE];
    char my_crlftrans[TYPICAL_STRING_SIZE];

    *output_string=0;

    if(*ps_color) {
        strcpy(my_color, ps_color);
    } else {
        strcpy(my_color, "Default");
    }
    if(*to_crlftrans){
        strcpy(my_crlftrans, to_crlftrans);
    } else {
        strcpy(my_crlftrans, "{}");
    }

    tellme_fully_which_printer_it_is(ps_gsdevice, ps_color, NULL, my_startentry);

    /* stair-stepping */
    sprintf(output_string, "##PRINTTOOL3## %s %s %s %s {} %s %s %s",
            ge_printer_type, ps_gsdevice, ps_resolution, ps_papersize,
            my_startentry, my_color, my_crlftrans);
}

/* sorts the given string list */
void sort_string_list(char *given_string_list)
{
    int my_size;
    char *read_point;
    char *my_buff;
    char my_last_string[TYPICAL_STRING_SIZE];
    char my_current_selection[TYPICAL_STRING_SIZE];
    char *write_point;

    *my_last_string=0;
    *my_current_selection=0;

    my_size=0;
    read_point=given_string_list;
    while(*read_point){
        while(*read_point++){
            my_size++;
        }
        my_size++;
    }
    my_size++;

    if((my_buff=(char *)malloc(my_size))){
        write_point=my_buff;

        while(*my_current_selection!=''){
            strcpy(my_current_selection, ""); /* certainly the last one */
            read_point=given_string_list;
            while(*read_point){
                if(strcmp(read_point, my_current_selection)<0){
                    if(strcmp(read_point, my_last_string)>0){
                        strcpy(my_current_selection, read_point);
                    }
                }
                read_point+=strlen(read_point)+1;
            }
            if(*my_current_selection!=''){
                strcpy(write_point, my_current_selection);
                write_point+=strlen(write_point)+1;
                strcpy(my_last_string, my_current_selection);
            }
        }
        *write_point=0;
    }

    memcpy(given_string_list, my_buff, my_size);
    free(my_buff);
}

/* given a string pointer, seeks for 0 and, then, returns the 0's
   address+1 (beginning of next string) */
/* returns NULL if that address also contains zero (end of string series) */
char *gimme_next_string(const char *from_this_point)
{
    const char *my_counter;

    my_counter=from_this_point;
    while(*(my_counter++));
    if(!(*my_counter))
        my_counter=NULL;

    return((char *)my_counter);
}

/* which_printer is the string just after 'Description: {' */
char *return_filter_propertylist(char *which_printer, char *which_property)
{
    FILE_CFG *my_file;
    int  myfilesize;
    char *my_buff;
    char *my_out_buff=NULL;
    char *my_secondary_buff;
    char *where_to_write;
    char the_printername[500];
    char *read_from_here;

//    if((my_file=fopen(PRINTERDB_FILENAME, "r"))){
    if((my_file=cf_printerdbfile.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            if((my_out_buff=(char *)malloc(myfilesize+1))){
                where_to_write=my_out_buff;
                *where_to_write=0;
                if((my_secondary_buff=(char *)malloc(myfilesize+1))){
                    int i;

                    i=0;
                    while(copy_specific_block(my_buff, "StartEntry: ", i++, my_secondary_buff)){
                        parse_string_data(my_secondary_buff, "Description: {", "}", the_printername);
                        if(!(strcmp(the_printername, which_printer))){
                            read_from_here=my_secondary_buff;
                            while((read_from_here=parse_string_data(read_from_here, which_property, "\n", where_to_write)))
                            {
                                where_to_write+=strlen(where_to_write)+1;
                            }
                            *where_to_write=0; /* makes the 2nd zero, meaning the list finished */
                        }
                    }
                }
            }
            free(my_buff);
        }
//        fclose(my_file);
        cf_printerdbfile.fclose(my_file);
    }
    return(my_out_buff);
}

/* allocate a string in memory and return its pointer
 containing all the printer filters' names.
 name1\0name2\0ame3\0.. ..\0last_name\0\0  */
/* it MUST be freed after then! free(blabla) */
char *return_filters_list(void)
{
    FILE_CFG *my_file;
    int  myfilesize;
    char *my_buff;
    char *my_out_buff=NULL;
    char *my_secondary_buff;
    char *where_to_write;

//    if((my_file=fopen(printerdb_filename, "r"))){
    if((my_file=cf_printerdbfile.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            if((my_out_buff=(char *)malloc(myfilesize+1))){
                where_to_write=my_out_buff;
                *where_to_write=0;
                if((my_secondary_buff=(char *)malloc(myfilesize+1))){
                    int i;

                    i=0;
                    while(copy_specific_block(my_buff, "StartEntry: ", i++, my_secondary_buff)){
                        parse_string_data(my_secondary_buff, "Description: {", "}", where_to_write);
                        where_to_write+=strlen(where_to_write)+1;
                    }
                    *where_to_write=0; /* makes the 2nd zero, meaning the list finished */
                }
            }
            free(my_buff);
        }
//        fclose(my_file);
        cf_printerdbfile.fclose(my_file);
    }

    /* sorts filterlist.. */
    sort_string_list(my_out_buff);

    return(my_out_buff);
}

/* if add_export=true, append a 'export ' before each entry */
void save_rhprt_config(char *my_parms, struct t_rh_array *where_to_go, char *printer_spool_path, int add_export)
{
    FILE_CFG *my_file;
    char whole_filename[500];
    char *my_pointer;
    int  my_counter;
    char data_to_file[500];

    my_pointer=my_parms;
    my_counter=0;

    sprintf(whole_filename, "%s/%s", printer_spool_path, my_parms);
	const char *user = "root";
	const char *group = "root";
	if(kind_of_lpr_system_installed==LPRTYPE_LPRNG){
		user = "$lprng_user";
		group = "$lprng_group";
	}
	CONFIG_FILE f_tmp (whole_filename,help_nil,CONFIGF_OPTIONAL
		,user,group,"$lprng_perm","lpd");

        if((my_file=f_tmp.fopen("w"))){
        fputs("#\n# This file was generated by Linuxconf's Printer module\n# according fileformat from RH's printtool\n#\n# Comments and unsupported entries may be lost!\n#\n\n", my_file);
        while((my_pointer=gimme_next_string(my_pointer))){
            if(add_export){
                sprintf(data_to_file, "export %s%s\n", my_pointer, where_to_go[my_counter++].d);
            } else {
                sprintf(data_to_file, "%s%s\n", my_pointer, where_to_go[my_counter++].d);
            }
            fputs(data_to_file, my_file);
        }
        fclose(my_file);
    }
}

/* load RH's printer config file to previously-allocated memory */
/* returns 0 if ok */
int load_rhprt_config(char *my_parms, struct t_rh_array *where_to_go, char *printer_spool_path)
{
    FILE *my_file;
    int  myfilesize;
    char *my_buff;
    char *my_pointer;
    int  my_counter;
    char whole_filename[500];

    my_pointer=my_parms;
    my_counter=0;

    sprintf(whole_filename, "%s/%s", printer_spool_path, my_parms);

    if((my_file=fopen(whole_filename, "r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);

            while((my_pointer=gimme_next_string(my_pointer))){
                parse_string_data(my_buff, my_pointer, "\n", where_to_go[my_counter++].d);
            }
            free(my_buff);
        }
        fclose(my_file);
        return(0);
    }
    return(1);
}

/* load config files in printer spool directory to memory
   if they don't exist, create them with defaults */
void load_initialise_secondary_configfiles(int which_printer)
{
    char tempy[PATH_MAX];

    /* creates filterscript in spool directory, if absent */
    sprintf(tempy, "%s/%s", my_printcap[which_printer].sd, FILTERSCRIPT_NAME);
	const char *user = "root";
	const char *group = "root";
	if(kind_of_lpr_system_installed==LPRTYPE_LPRNG){
		user = "$lprng_user";
		group = "$lprng_group";
	}
    CONFIG_FILE f_tmp (tempy,help_nil,CONFIGF_OPTIONAL
		,user,group,"$lprng_perm","lpd");

    if(!f_tmp.exist()){
        FILE_CFG *my_filter;
        FILE_CFG *my_master_filter;
        int  myfilesize;
        char *my_buff;

        if((my_filter=f_tmp.fopen("w"))){
            if((my_master_filter=cf_masterfilterfile.fopen("r"))){
            // if((my_master_filter=fopen(MASTERFILTER_FULLPATH, "r"))){
                /* read file to memory.. */
                fseek(my_master_filter, 0, SEEK_END);
                myfilesize=ftell(my_master_filter);
                fseek(my_master_filter, 0, SEEK_SET);

                if((my_buff=(char *)malloc(myfilesize+1))){
                    if(fread(my_buff, myfilesize, 1, my_master_filter)){
                        *(my_buff+myfilesize)=0;
                        /* write it.. */
                        fputs(my_buff, my_filter);
                    }
                    cf_masterfilterfile.fclose(my_master_filter);
                    free(my_buff);
                }else{
                    cf_masterfilterfile.fclose(my_master_filter);
                }

            } else { /* this is unlikely to happen, but it will put my own filter instead if RH's one is not accessible */
                fputs("#!/bin/bash\n\n# this filterscript was generated by Linuxconf's Printer module\n", my_filter);
                fputs("# currently it only uses the postscript.cfg file, but it may change in future\n\n", my_filter);
                fputs("export SPOOLDIR=$(pwd)\n\nsource ${SPOOLDIR}/postscript.cfg\n# source ${SPOOLDIR}/general.cfg\n# source ${SPOOLDIR}/textonly.cfg\n", my_filter);
                fputs("\n", my_filter);
                fputs("if [ \"$GSDEVICE\" != \"TEXT\" ]; then\n", my_filter);
                fputs("   if [ \"$RESOLUTION\" != \"NAxNA\" ]; then\n", my_filter);
                fputs("      nenscript -TA4 -ZB -p- |\n", my_filter);
                fputs("      gs -q -sDEVICE=$GSDEVICE \\\n", my_filter);
                fputs("              -r$RESOLUTION \\\n", my_filter);
                fputs("              -sPAPERSIZE=$PAPERSIZE \\\n", my_filter);
                fputs("              -dNOPAUSE \\\n              -dSAFER \\\n", my_filter);
                fputs("              $COLOR \\\n", my_filter);
                fputs("              $EXTRA_GS_OPTIONS \\\n", my_filter);
                fputs("              -sOutputFile=- -\n", my_filter);
                fputs("   else\n", my_filter);
                fputs("      nenscript -TA4 -ZB -p- |\n", my_filter);
                fputs("      gs -q -sDEVICE=$GSDEVICE \\\n", my_filter);
                fputs("              -sPAPERSIZE=$PAPERSIZE \\\n", my_filter);
                fputs("              -dNOPAUSE \\\n              -dSAFER \\\n", my_filter);
                fputs("              $COLOR \\\n", my_filter);
                fputs("              $EXTRA_GS_OPTIONS \\\n", my_filter);
                fputs("              -sOutputFile=- -\n", my_filter);
                fputs("   fi\n", my_filter);
                fputs("else\n   cat -\nfi\n\n", my_filter);

                fputs("\nif [ \"$PS_SEND_EOF\" == \"\" ]; then\n", my_filter);
                fputs("        printf \"\\004\"\nfi\n", my_filter);
            }
            fclose(my_filter);
        }
    }

    /* postscript.cfg */
    sprintf(tempy, "%s/%s", my_printcap[which_printer].sd, ps_cfg_tag);
    if(!this_file_exists(tempy)){
        strcpy(ps_gsdevice, "TEXT");
        strcpy(ps_resolution, "NAxNA");
        *ps_color=0;
        strcpy(ps_papersize, "a4");
        strcpy(ps_extra_gs_options, "\"\"");
        *ps_reverse_order=0;
        strcpy(ps_send_eof, "NO");
        strcpy(ps_nup, "1");
        strcpy(ps_rtlftmar, "18");
        strcpy(ps_topbotmar, "18");
    } else {
        load_rhprt_config(ps_cfg_tag, ps_cfg, my_printcap[which_printer].sd);
        /* adjust ps_color data */
        {
            char *where_it_should_begin;
            char tempy2[TYPICAL_STRING_SIZE];

            if(*ps_color){
                if((where_it_should_begin=strchr(ps_color, '='))){
                    strcpy(tempy2, ++where_it_should_begin);
                    strcpy(ps_color, tempy2);
                }
            }
        }
    }

    /* textonly.cfg */
    sprintf(tempy, "%s/%s", my_printcap[which_printer].sd, to_cfg_tag);
    if(!this_file_exists(tempy)){
        *to_textonlyoptions=0;
        *to_crlftrans=0;
        strcpy(to_text_send_eof, "NO");
    } else {
        load_rhprt_config(to_cfg_tag, to_cfg, my_printcap[which_printer].sd);
    }

    /* general.cfg */
    sprintf(tempy, "%s/%s", my_printcap[which_printer].sd, ge_cfg_tag);
    if(!this_file_exists(tempy)){
        strcpy(ge_desired_to, "ps");
        strcpy(ge_papersize, "a4");
        // strcpy(ge_printer_type, "LOCAL"); /* not defined here */
        strcpy(ge_ascii_to_ps, "NO");
    } else {
        load_rhprt_config(ge_cfg_tag, ge_cfg, my_printcap[which_printer].sd);
    }

    /* define everything defined before (from printcap) */
    strcpy(ge_printer_type, "LOCAL");
    switch(return_printer_type(which_printer)){
    case PRT_REMOTE:
        strcpy(ge_printer_type, "REMOTE");
        break;
    case PRT_SMBWIN:
        strcpy(ge_printer_type, "SMB");
        break;
    case PRT_NETWARE:
        strcpy(ge_printer_type, "NCP");
        break;
    case PRT_DIRECT:
        strcpy(ge_printer_type, "DIRECT");
        break;
    }

    /* patches the -dBitsPerPixel=NONONONO thing */
    {
        char tempz[TYPICAL_STRING_SIZE];
        char *where_copy_from;

        strcpy(tempz, ps_color);
        if(*ps_color){
            if((where_copy_from=strchr(ps_color, '=')))
                strcpy(tempz, ++where_copy_from);
        }

        /* if the filter description is not found in internal linuxconf configfile..
           try to guess based on the filtername */
        {
            const char *readen_filterdesc;

            /* ok, now let's get the filter description from linuxconf global configfile
               _or_ guess it */
            if((readen_filterdesc=read_filter_description(which_printer))){
                strcpy(f_printername, readen_filterdesc);
            }else{
                tellme_which_printer_it_is(ps_gsdevice, tempz, f_printername);
            }
        }
    }
}

/* dump all the current printer's filter data to right files.. */
/* this what is called when user clicked the button for saving preferences */
void save_all_the_filters_stuff(int which_printer)
{
    save_from_gui_variables();

    /* adjust ps_color data, attach '-dBitsPerPixel=%s'
       but NOT if postscript driver is 'uniprint' */
    if((*ps_color)&&(strcmp(ps_gsdevice, "uniprint")&&(strcmp(ps_gsdevice, "ppa")))){
        char tempy2[TYPICAL_STRING_SIZE];

        sprintf(tempy2, "-dBitsPerPixel=%s", ps_color);
        strcpy(ps_color, tempy2);
    }
    /* postscript.cfg */
    save_rhprt_config(ps_cfg_tag, ps_cfg, my_printcap[which_printer].sd, 0);

    /* textonly.cfg */
    save_rhprt_config(to_cfg_tag, to_cfg, my_printcap[which_printer].sd, 0);

    /* general.cfg */
    save_rhprt_config(ge_cfg_tag, ge_cfg, my_printcap[which_printer].sd, 1);

    /* remove the heading '-dBitsPerPixel=' from ps_color, if it was previously added */
    if(*ps_color){
        char tempz[TYPICAL_STRING_SIZE];
        char *where_copy_from;

        strcpy(tempz, ps_color);
        if((where_copy_from=strchr(ps_color, '='))){
            strcpy(tempz, ++where_copy_from);
            strcpy(ps_color, tempz);
        }
    }
}

/* fills with right printername (Description:) from given specs */
void tellme_which_printer_it_is(char *given_gsdriver, char *given_colordepth, char *output_string)
{
    tellme_fully_which_printer_it_is(given_gsdriver, given_colordepth, output_string, NULL);
}

/* fills with right printername (Description:) from given specs */
/* if secondary output not null, it also returns the StartEntry: field */
void tellme_fully_which_printer_it_is(char *given_gsdriver, char *given_colordepth, char *output_string, char *secondary_output)
{
    FILE_CFG *my_file;
    int  myfilesize;
    char *my_buff;
    char *my_secondary_buff;
    char seek_for[TYPICAL_STRING_SIZE];
    char string_ends_with[10];
    char matchs_with[TYPICAL_STRING_SIZE];
    char temp_output[500];
    char *read_from_here;

    if(output_string)
        *output_string=0;
    if(secondary_output)
        *secondary_output=0;

    /* if not 'ppa' nor 'uniprint', normal filter */
    if((strcmp(given_gsdriver, "uniprint"))&&(strcmp(given_gsdriver, "ppa"))){
        strcpy(seek_for, "GSDriver: ");
        sprintf(string_ends_with, "\n");
        strcpy(matchs_with, given_gsdriver);
    }else{
        strcpy(seek_for, "BitsPerPixel: {");
        strcpy(string_ends_with, "}");
        strcpy(matchs_with, given_colordepth);
    }

//    if((my_file=fopen(printerdb_filename, "r"))){
    if((my_file=cf_printerdbfile.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            if((my_secondary_buff=(char *)malloc(myfilesize+1))){
                int i;

                i=0;
                while(copy_specific_block(my_buff, "StartEntry: ", i++, my_secondary_buff)){
                    read_from_here=my_secondary_buff;
                    while((read_from_here=parse_string_data(read_from_here, seek_for, string_ends_with, temp_output))){
                        if(!strcmp(matchs_with, temp_output)){
                            if(output_string)
                                parse_string_data(my_secondary_buff, "Description: {", "}", output_string);
                            if(secondary_output)
                                parse_string_data(my_secondary_buff, "StartEntry: ", "\n", secondary_output);
                        }
                    }

                }
            }
            free(my_buff);
        }
//        fclose(my_file);
        cf_printerdbfile.fclose(my_file);
    }
}

/* given a string
 {blablabla0} {blablabla1} {blablabla2} ..
 copies the specified element between the {}
 (element1 means 'blablabla1')
 */
void gimme_string_element(char *given_string, int which_element, char *output_string)
{
    char *my_pointer;
    char *my_output_pointer;
    int  my_counter;

    my_pointer=given_string-1;
    my_counter=which_element+1;
    my_output_pointer=output_string;

    while((my_counter--)&&my_pointer){
        my_pointer=strchr(++my_pointer, '{');
    }
    if((my_pointer)){
        my_pointer++;
        while(my_pointer&&(*my_pointer)&&(*my_pointer!='}')){
            *my_output_pointer++=*my_pointer++;
        }
    }
    *my_output_pointer=0;
}














/* save the printcap configuration */
void save_all_printers_data(void)
{
    FILE_CFG *printcap_file;
    int  i;
       
//    if((printcap_file=fopen(PRINTCAP_LOCATION, "w"))){
    if((printcap_file=cf_printcapfile.fopen("w"))){
    char tempy[300];
        
        sprintf(tempy, "# %s\n#\n# This file was generated by Linuxconf's Printer module\n", PRINTCAP_LOCATION);
        fputs(tempy, printcap_file);
        sprintf(tempy, "# You may edit this file directly, but only standard printcap entries\n# will be preserved.\n");
        fputs(tempy, printcap_file);

        i=0;
//        while (i<MAX_PRINTERS){
        while (i<total_printer_entries){
            if(general_printer_index[i].exists){
                /* insert ##PRINTTOOL3## line */
                load_initialise_secondary_configfiles(i);
                create_commented_printcap_config(tempy);
                fputs("\n", printcap_file);
                fputs(tempy, printcap_file);
                fputs("\n", printcap_file);
                /* now inserts the conventional printcap data */
                sprintf(tempy, "%s:", general_printer_index[i].devname);
                save_dataprintcap(&my_printcap[i], printcap_file, tempy);
            }
            i++;
        }
        
        sprintf(tempy, "\n");
        fputs(tempy, printcap_file);
//        fclose(printcap_file);
        cf_printcapfile.fclose(printcap_file);
    }
}

/* load work variables to gui variables
 (because the char-SSTRING conversion, the char-string conversion, etc) */
/* (remember when creating writting routine: mirror values between archives */
void load_to_gui_variables(void)
{
    /* loads filter description */
    {
        char *temps;

        temps=return_filter_propertylist(f_printername, "About: ");
        gimme_string_element(temps, 0, f_filterdescription);
        free(temps);
    }

    f_resolution.setfrom(ps_resolution);
    f_papersize.setfrom(ps_papersize);
    f_colordepth.setfrom(ps_color);
    f_printedpages.setfrom(ps_nup);

    if(!strcmp(ps_send_eof, "NO")){
        f_sendeof=0;
    } else {
        f_sendeof=1;
    }

    if(!strcmp(to_crlftrans, "1")){
        f_correctcrlf=1;
    } else {
        f_correctcrlf=0;
    }

    if(!strcmp(ge_ascii_to_ps, "NO")){
        f_fastascii=1;
    } else {
        f_fastascii=0;
    }

    f_horizmargins=atoi(ps_rtlftmar);
    f_vertmargins=atoi(ps_topbotmar);

    /* copy but eliminates first and last characters (those ") */
    strcpy(f_extragsopt, ps_extra_gs_options+1);
    {
        int tempi;

        if((tempi=strlen(f_extragsopt))){
            *(f_extragsopt+tempi-1)=0;
        }
    }
}

/* same as load_to_gui_variables, but in an opposite way :) */
void save_from_gui_variables(void)
{
    strcpy(ps_resolution, f_resolution.get());
    strcpy(ps_papersize, f_papersize.get());
    strcpy(ge_papersize, f_papersize.get());
    strcpy(ps_color, f_colordepth.get());
    strcpy(ps_nup, f_printedpages.get());

    if(f_sendeof){
        *ps_send_eof=0;
    } else {
        strcpy(ps_send_eof, "NO");
    }

    if(f_correctcrlf){
        strcpy(to_crlftrans, "1");
    } else {
        *to_crlftrans=0;
    }

    if(f_fastascii){
        strcpy(ge_ascii_to_ps, "NO");
    } else {
        *ge_ascii_to_ps=0;
    }

    sprintf(ps_rtlftmar, "%d", f_horizmargins);
    sprintf(ps_topbotmar, "%d", f_vertmargins);

    /* puts the " back as needed for config file */
    sprintf(ps_extra_gs_options, "\"%s\"", f_extragsopt);
}

/* load printcap data (other printers' data will be loaded in different parts of code) */
void load_printcap(void)
{
    int i;

    /* initially there are 0 printers (blocks allocated) */
    total_printer_entries=0;


    total_printer_entries++;
    general_printer_index=(t_general_printer_index *)malloc(sizeof(t_general_printer_index));
    my_printcap=(t_dataprintcap *)malloc(sizeof(t_dataprintcap));

    i=0;
    while(load_dataprintcap(&my_printcap[i], i)){
        general_printer_index[i].exists=1;
        strcpy(general_printer_index[i].devname, my_printcap[i].printer_name);

        total_printer_entries++;
        realloc_buffers_of_mine();
        i++;
    }

    /* ok, mission is complete.. let's free that empty additionally-allocated entry */
    total_printer_entries--;
    realloc_buffers_of_mine();

/*
    i=MAX_PRINTERS;
    while(i--){
        general_printer_index[i].exists=0;
        *(general_printer_index[i].devname)=0;
        *(general_printer_index[i].type)=0;
    }

    i=0;
    while(load_dataprintcap(&my_printcap[i], i)){
        general_printer_index[i].exists=1;
        strcpy(general_printer_index[i].devname, my_printcap[i].printer_name);
        i++;
    }
    */
}

/* reallocs my_printcap and general_printer_index buffers
   to reflect the current total_printer_entries */
void realloc_buffers_of_mine(void)
{
    general_printer_index=(t_general_printer_index *)realloc(general_printer_index, (sizeof(t_general_printer_index)*total_printer_entries));
    my_printcap=(t_dataprintcap *)realloc(my_printcap, (sizeof(t_dataprintcap)*total_printer_entries));
}

void free_buffers_of_mine(void)
{
    free(general_printer_index);
    free(my_printcap);
}

/* checks is given printername is present in the given list
 (ex.: lp3 is in lp3|bobobo|nanana but not in lp34|bibibi)
 (ex.2: lp3|eca is in eca|nanana|nonono)
 returns true if it is present. */
int is_this_printer_there(const char *given_printername, const char *given_printerlist)
{
    SSTRING seek_for_this_one;
    SSTRING found_printername;
    int my_loop, my_loop2=0;

    while(gimme_word_from_string_bchar(given_printername, seek_for_this_one, my_loop2++, '|')){
        my_loop=0;
        while(gimme_word_from_string_bchar(given_printerlist, found_printername, my_loop++, '|')){
            if(!strcmp(found_printername.get(), seek_for_this_one.get()))
                return(1);
        }
    }

    return(0);
}

/* returns true if printcap is LPRng-style (no reversed dashes present).. */
/* it'll also return false if file cannot be readen.. well.. */
int is_printcap_lprng_style(void)
{
    FILE_CFG *printcapfile;
    int  myfilesize;
    char *my_buff;
    int  what_code_to_return=0;

    if((printcapfile=cf_printcapfile.fopen("r"))){
    fseek(printcapfile, 0, SEEK_END);
        myfilesize=ftell(printcapfile);
        fseek(printcapfile, 0, SEEK_SET);

        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, printcapfile);

            /* here it analyses the file data */
            if(strchr(my_buff, ':')){
                char *my_pointer;

                what_code_to_return=1;
                my_pointer=my_buff;
                while((my_pointer=strchr(my_pointer, '\\'))){
                    my_pointer++;
                    while(*my_pointer==' ')
                        my_pointer++;
                    if(*my_pointer=='\n')
                        what_code_to_return=0;
                }
            }

            free(my_buff);
        }
        cf_printcapfile.fclose(printcapfile);
    }
    return(what_code_to_return);
}

/* says if old lpr system is being used, or LPRng.. */
/* (currently only old_RH_lpr and LPRng are supported) */
int return_lpr_system_installed_in_this_system(void)
{
    char fried_chicken[1024];

    execute_proggy_and_get_stdout("lpd -V 2>&1", fried_chicken, 1023);
    if(strstr(fried_chicken, "LPRng")){
        return(LPRTYPE_LPRNG);
    }

    return(LPRTYPE_OLD_LPR);
}

/* will reset resolution and colordepth for first permitted values
   (because new filter installed) */
/* given the selected filtername */
/* UNFINISHED */
void new_filter_so_reset_some_things(char *overrider_printer)
{
    char *my_new_gs_driver;
    char *my_new_resolution;
    char *my_new_colordepth;
    char tempy[TYPICAL_STRING_SIZE];
    char tempy2[TYPICAL_STRING_SIZE];

    /* f_printername redefined.. */
    strcpy(f_printername, overrider_printer);

    my_new_gs_driver=return_filter_propertylist(overrider_printer, "GSDriver: ");
    my_new_resolution=return_filter_propertylist(overrider_printer, "Resolution: ");
    my_new_colordepth=return_filter_propertylist(overrider_printer, "BitsPerPixel: ");

    if(!(strcmp(my_new_gs_driver, "ppa"))) /* ppa printers shall not have fast ascii enabled */
        f_fastascii=0;

    /* ps_gsdevice redefined.. */
    strcpy(ps_gsdevice, my_new_gs_driver);

    /* ps_resolution redefined.. */
    gimme_string_element(my_new_resolution, 0, tempy);
    gimme_string_element(my_new_resolution, 1, tempy2);
    sprintf(ps_resolution, "%sx%s", tempy, tempy2);

    /* ps_color redefined.. */
    gimme_string_element(my_new_colordepth, 0, ps_color);

    free(my_new_colordepth);
    free(my_new_resolution);
    free(my_new_gs_driver);
}

/* filed popup menus with printerdb data, according the printer selected */
/* processing:
 0-none
 1-{300} {300} {}            to  300x300
 2-{blabla0} {blablabla..}   to  blabla0, blablabla..
 */
/* returns how many items were added */
int populate_sstrings(char *filter_id, char *field_identificator, int processing, SSTRINGS &descriptions, SSTRINGS &values)
{
    char *generated_list;
    char *readpoint;
    char my_desc[500];
    char my_retcod[500];
    int  how_many_added=0;

    generated_list=return_filter_propertylist(filter_id, field_identificator);
    readpoint=generated_list;

    while(*readpoint){
        switch(processing){
        case 0:
            strcpy(my_desc, readpoint);
            strcpy(my_retcod, readpoint);
            break;
        case 1:
            {
                char xres[20],
                     yres[20],
                     commentres[100];

                gimme_string_element(readpoint, 0, xres);
                gimme_string_element(readpoint, 1, yres);
                gimme_string_element(readpoint, 2, commentres);
                sprintf(my_retcod, "%sx%s", xres, yres);
                if(*commentres){
                    sprintf(my_desc, "%s (%s)", my_retcod, commentres);
                } else {
                    sprintf(my_desc, "%s", my_retcod);
                }
            }
            break;
        case 2:
            {
                gimme_string_element(readpoint, 0, my_retcod);
                gimme_string_element(readpoint, 1, my_desc);
            }
            break;

        }
        if(strcmp("NAxNA", my_desc)){ // if != "NAxNA"
            descriptions.add(new SSTRING(my_desc));
            values.add(new SSTRING(my_retcod));
            how_many_added++;
        }
        readpoint+=strlen(readpoint)+1;
    }
    free(generated_list);
    return(how_many_added);
}

/* given_number = printer number from 0 to N-1 (N = total of printers)
 returns the _real_ location (which may be the same number, or not
 if there's some empty printcap 'slot' in the middle of the list */
/* returns -1 is printer does not exist */
int translate_printer_number(int given_number)
{
    int my_counter=0;
    int i=0;

    while(i<total_printer_entries){
        if(general_printer_index[i].exists){
            if(my_counter==given_number)
                return(i);
            my_counter++;
        }
        i++;
    }
    return(-1);
}

/* returns a virtual number for a _real_ location given
   (the printcap 'slot') */
/* return -1 if the given location does not exist or
   is empty */
int return_virtual_printer_number(int given_number)
{
    int my_counter=0;
    int i=0;

    while(i<total_printer_entries){
        if(i==given_number){
            if(general_printer_index[i].exists){
                return(my_counter);
            }else{
                return(-1);
            }
        }
        if(general_printer_index[i].exists)
            my_counter++;
        i++;
    }
    return(-1);
}



/* returns a vacant slot (or creates a new one and returns its code)
   used when creating a new printer entry */
int returns_free_slot(void)
{
    int free_slot=-1;
    int i=0;

    while(i<total_printer_entries){
        if(general_printer_index[i].exists){
            i++;
        } else {
            free_slot=i;
            i=total_printer_entries;
        }
    }
    if(free_slot==-1){
        total_printer_entries++;
        realloc_buffers_of_mine();
        free_slot=total_printer_entries-1;

        /* cleans the newly-allocated slot */
        general_printer_index[total_printer_entries-1].exists=0;
        *(general_printer_index[total_printer_entries-1].devname)=0;
        *(general_printer_index[total_printer_entries-1].type)=0;
    }
    return(free_slot);
}

/* create directory and all initially needed stuff */
/* non-zero = failure */
int create_printer_files(char *printer_name_full_path)
{
    int ret = -1;
    if(kind_of_lpr_system_installed==LPRTYPE_LPRNG){
        ret = file_mkdirp (printer_name_full_path, "$lprng_user","$lprng_group","$lprng_perm");
    }else{
    	ret = file_mkdirp (printer_name_full_path, "root","root",0755);
    }
    if (ret == -1){
    // ADICIONAR ROTINA DE VERIFICAO SE  REALMENTE UM DIRETRIO
    if(!confirm_yesno_window(MSG_U(M_COULDNTCREATEPRTDIRTT, "Unable to create printer directory"), MSG_U(M_COULDNTCREATEPRTDIRTX2, "It's likely there's already a spool directory\nwith the same name as this printer\nyou want to create.\n\nPerhaps this directory was left when you\ndeleted the printer which used it.\n\nDo you want to use this directory for the new printer?\n(its contents will be left untouched)"))){
        return(1);
    }
//        informational_window(MxxSxxG_U(M_COULDNTCREATEPRTDIRTT, "Unable to create printer directory"),
//                             MxxSxxG_U(M_COULDNTCREATEPRTDIRTX, "An error occurred while creating the printer directory.\nTry using another printer name."));

    }
    return(0);
}

/* printer type may be:
    PRT_LOCAL
    PRT_REMOTE
    PRT_SMBWIN
    PRT_NETWARE
    PRT_DIRECT
*/
/* returns -1 if error, or the slot where the printer was created */
int create_a_printer(char type_printr, char *printer_name, char *my_fullspoolpath)
{
    int free_slot;

    free_slot=returns_free_slot();

    if(create_printer_files(my_fullspoolpath))
        return(-1);
    
    /* setup new printer defaults */
    general_printer_index[free_slot].exists=1;
    strcpy(general_printer_index[free_slot].devname, printer_name);
    load_printcap_defaults(&my_printcap[free_slot]);
    strcpy(my_printcap[free_slot].sd, my_fullspoolpath);

    sprintf(my_printcap[free_slot].if_, "%s/%s", my_fullspoolpath, FILTERSCRIPT_NAME);
    /* if LPRng _and_ printer is remote queue adds lpd_bounce tag */
    if((kind_of_lpr_system_installed==LPRTYPE_LPRNG)&&(type_printr==PRT_REMOTE))
        my_printcap[free_slot].lpd_bounce=1;

    /* now the printer is added to system */
    switch(type_printr)
    {
    case PRT_LOCAL:
        strcpy(my_printcap[free_slot].lp, DEFAULT_PRTDEVICE);
        break;
    case PRT_REMOTE:
        strcpy(my_printcap[free_slot].rp, DEFAULT_PRTREMOTEQUEUE);
        strcpy(my_printcap[free_slot].rm, MSG_U(M_SOMEMACHMYNETWORK, "somemachine.mynetwork"));
        break;
    case PRT_SMBWIN:
//        strcpy(my_printcap[free_slot].if_, DEFAULT_PRTFULLPATHSMBFILTER);
        strcpy(my_printcap[free_slot].lp, DEFAULT_PRTSMBDEVICE);
        dump_this_string_to_given_file("share=\'\\\\printer_hostname\\remote_printername\'\nhostip=\nuser=\'username_for_this\'\npassword=\'\'\nworkgroup=\'my_workgroup\'\n",
                                       DOTCONFIG_FILENAME,
                                       my_printcap[free_slot].sd);
        {
            char ge_cfg_tag[]="general.cfg\0DESIRED_TO=ps\0PAPERSIZE=a4\0PRINTER_TYPE=\0ASCII_TO_PS=NO\0\0";
            struct t_rh_array ge_cfg[4];

            ge_cfg[0].d[0]=0;
            ge_cfg[1].d[0]=0;
            strcpy(ge_cfg[2].d, "SMB");
            ge_cfg[3].d[0]=0;

            save_rhprt_config(ge_cfg_tag, ge_cfg, my_printcap[free_slot].sd, 1);
        }
        break;
    case PRT_NETWARE:
//        strcpy(my_printcap[free_slot].if_, DEFAULT_PRTFULLPATHNCPFILTER);
        strcpy(my_printcap[free_slot].lp, DEFAULT_PRTNCPDEVICE);
        dump_this_string_to_given_file("server=my_server\nqueue=my_queue\nuser=username_for_this\npassword=\n",
                                       DOTCONFIG_FILENAME,
                                       my_printcap[free_slot].sd);
        {
            char ge_cfg_tag[]="general.cfg\0DESIRED_TO=\0PAPERSIZE=\0PRINTER_TYPE=\0ASCII_TO_PS=NO\0\0";
            struct t_rh_array ge_cfg[4];

            ge_cfg[0].d[0]=0;
            ge_cfg[1].d[0]=0;
            strcpy(ge_cfg[2].d, "NCP");
            ge_cfg[3].d[0]=0;

            save_rhprt_config(ge_cfg_tag, ge_cfg, my_printcap[free_slot].sd, 1);
        }
    case PRT_DIRECT:
//        strcpy(my_printcap[free_slot].if_, DEFAULT_PRTFULLPATHNCPFILTER);
        strcpy(my_printcap[free_slot].lp, DEFAULT_PRTNCPDEVICE);
        dump_this_string_to_given_file("server=\nqueue=\nuser=\npassword=\nport=my_port\nprinter_ip=my_printer_ip\n",
                                       DOTCONFIG_FILENAME,
                                       my_printcap[free_slot].sd);
        {
            char ge_cfg_tag[]="general.cfg\0DESIRED_TO=\0PAPERSIZE=\0PRINTER_TYPE=\0ASCII_TO_PS=NO\0\0";
            struct t_rh_array ge_cfg[4];

            ge_cfg[0].d[0]=0;
            ge_cfg[1].d[0]=0;
            strcpy(ge_cfg[2].d, "DIRECT");
            ge_cfg[3].d[0]=0;

            save_rhprt_config(ge_cfg_tag, ge_cfg, my_printcap[free_slot].sd, 1);
        }

        // sprintf(my_printcap[free_slot].af, DEFAULT_PRTACCOUNT_NAME, printer_name);
    }

    save_all_printers_data();

    /* removes old variable, if present in linuxconf global configfile */
    {
        char mtemp[TYPICAL_STRING_SIZE];

        sprintf(mtemp, "%s%s", printer_name, "_filterdesc");
        linuxconf_removeall ("printer", mtemp);
        linuxconf_save();
    }

    return(free_slot);
}

/* does not automatically save the printcap data
   do NOT forget to do that! */
void remove_printer(int which_printer)
{
    char tempy[500];

    general_printer_index[which_printer].exists=0;
//            (void)save_all_printers_data(); /* let's make sure noone will try to user this printer from now */
    remove_filter_description(which_printer); /* removes filtername from linuxconf global config file */

    /* now removes the printer directory and its files */
    if(my_printcap[which_printer].sd){
        if(zaapboom_directory(my_printcap[which_printer].sd)){
            sprintf(tempy, MSG_U(M_COULDNTREMOVEPRTTX, "Could not remove printer's files and/or its directory.\nYou have to manually remove the following directory:\n%s\n"), my_printcap[which_printer].sd);
            informational_window(MSG_U(M_COULDNTREMOVEPRTTT, "Unable to remove printer's directory"), tempy);
        }
    }
}

