
/* interface to Printer GURU */

#include <string.h>
#include <stdlib.h>

#include <modapi.h>
#include <fviews.h>

#include "printer_fi.h"
#include "printer_gi.h"
#include "printer_smbncp-specific.h"
#include "printer.m"
#include "printer_printcap.h"

/* returns all the filters available (filters' descriptions) */
/* does not empty drop_here, just adds new SSTRING there */
/* return code: number os filters returned */
int gi_return_filtersnames(SSTRINGS &drop_here)
{
    char *list_filter;
    int total_items=0;
    char *current_item;

    if((list_filter=return_filters_list())){
        current_item=list_filter;
        while(current_item){
            drop_here.add(new SSTRING(current_item));
            current_item=gimme_next_string(current_item);
        }

        free(list_filter);
    }
    return(total_items);
}

/* returns all the printers (queues) present in the system
 ex.: lp, lp2|blah, lp3|laserjet */
/* returns the total os printers present in the system */
/* the which_printer_v entries (present in other functions here)
   reflects THIS list */
int gi_return_printers_list(SSTRINGS &drop_here)
{
    int total_items_added=0;
    int i=0;

    while(i<total_printer_entries){
        if(general_printer_index[i].exists){
            drop_here.add(new SSTRING(general_printer_index[i].devname));
            total_items_added++;
        }
        i++;
    }
    return(total_items_added);
}

/* loads a specific printer's properties into a specified t_printer_props
   structure */
void gi_return_printer_data(int which_printer_v, t_printer_props &drop_here)
{
    char   dotconfig_fullpath[500];
    int which_printer;
    which_printer=translate_printer_number(which_printer_v);


    sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);

    load_initialise_secondary_configfiles(which_printer);
    load_to_gui_variables();
    load_dotconfig_data(dotconfig_fullpath);


    drop_here.printer_type=return_printer_type(which_printer);

    drop_here.printername.setfrom(my_printcap[which_printer].printer_name);

    drop_here.f_printername.setfrom(f_printername);
    drop_here.f_description.setfrom(f_filterdescription);
    drop_here.f_resolution.setfrom(f_resolution.get());
    drop_here.f_papersize.setfrom(f_papersize.get());
    drop_here.f_colordepth.setfrom(f_colordepth.get());
    drop_here.margin_horiz=f_horizmargins;
    drop_here.margin_vert=f_vertmargins;
    drop_here.extra_gsopts.setfrom(f_extragsopt);
    drop_here.send_eof=f_sendeof;
    drop_here.correct_crlf=f_correctcrlf;
    drop_here.fastascii=f_fastascii;

    drop_here.use_device.setfrom(my_printcap[which_printer].lp);
    drop_here.remote_machine.setfrom(my_printcap[which_printer].rm);
    drop_here.remote_queue.setfrom(my_printcap[which_printer].rp);
    drop_here.user.setfrom(dc_var.user);
    drop_here.password.setfrom(dc_var.password);
    drop_here.hostname.setfrom(dc_var.hostname);
    drop_here.remote_printername.setfrom(dc_var.printername);
    drop_here.hostip.setfrom(dc_var.hostip);
    drop_here.workgroup.setfrom(dc_var.workgroup);
    drop_here.server.setfrom(dc_var.server);
    drop_here.netw_queue.setfrom(dc_var.queue);
}

/* write back the printer settings (except the read-only fields,
   which are kept original - obviously) */
void gi_write_printer_data(int which_printer_v, t_printer_props &get_from)
{
    char   dotconfig_fullpath[500];
    int which_printer;
    which_printer=translate_printer_number(which_printer_v);


    sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);

    f_resolution.setfrom(get_from.f_resolution.get());
    f_papersize.setfrom(get_from.f_papersize.get());
    f_colordepth.setfrom(get_from.f_colordepth.get());
    f_horizmargins=get_from.margin_horiz;
    f_vertmargins=get_from.margin_vert;
    strncpy(f_extragsopt, get_from.extra_gsopts.get(), TYPICAL_STRING_SIZE-1);
    f_sendeof=get_from.send_eof;
    f_correctcrlf=get_from.correct_crlf;
    f_fastascii=get_from.fastascii;

    strncpy(my_printcap[which_printer].lp, get_from.use_device.get(), TYPICAL_STRING_SIZE-1);
    strncpy(my_printcap[which_printer].rm, get_from.remote_machine.get(), TYPICAL_STRING_SIZE-1);
    strncpy(my_printcap[which_printer].rp, get_from.remote_queue.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.user, get_from.user.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.password, get_from.password.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.hostname, get_from.hostname.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.printername, get_from.remote_printername.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.hostip, get_from.hostip.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.workgroup, get_from.workgroup.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.server, get_from.server.get(), TYPICAL_STRING_SIZE-1);
    strncpy(dc_var.queue, get_from.netw_queue.get(), TYPICAL_STRING_SIZE-1);

    save_all_the_filters_stuff(which_printer);
    save_dotconfig_data(dotconfig_fullpath);
    save_all_printers_data(); // save printcap
}

/* set a new filter and set options such as printer resolution
   to the first filter options available */
/* assume drop_here was previosly loaded with current printer values */
/* important: it SAVES the current printer settings */
void gi_select_new_filter(int which_printer_v, t_printer_props &drop_here, const char *use_filter)
{
    int which_printer;
    which_printer=translate_printer_number(which_printer_v);

    save_from_gui_variables();
    new_filter_so_reset_some_things((char *)use_filter);
    load_to_gui_variables();
    write_filter_description(which_printer, (char *)use_filter);
    save_all_the_filters_stuff(which_printer);
    save_all_printers_data();

    gi_return_printer_data(which_printer, drop_here);
}

/* returns the available options for the lists
   it'll never return empty SSTRINGS */
void gi_returns_lists(int which_printer_v, t_printer_props &get_from, t_avail_opts &dump_here)
{
    int which_printer;
    which_printer=translate_printer_number(which_printer_v);

    if(!populate_sstrings(f_printername, "Resolution: ", 1, dump_here.f_resolution_desc, dump_here.f_resolution)){
        dump_here.f_resolution_desc.add(new SSTRING(MSG_R(M_NOTAVAIL)));
        dump_here.f_resolution.add(new SSTRING("NAxNA"));
    }
    if(!populate_sstrings(f_printername, "BitsPerPixel: ", 2, dump_here.f_colordepth_desc, dump_here.f_colordepth)){
        dump_here.f_colordepth_desc.add(new SSTRING(MSG_R(M_NOTAVAIL2)));
        dump_here.f_colordepth.add(new SSTRING(""));
    }

    /* this looks ridiculous */

    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPE1117)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA0)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA1)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA2)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA3)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA4)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA5)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA6)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA7)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA8)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA9)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEA10)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEARA)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEARB)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEARC)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEARD)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEARE)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB0)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB1)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB2)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB3)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB4)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEB5)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEFLSA)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEFLSE)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPEHLET)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPELEDG)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPELEGAL)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPELETTER)));
    dump_here.f_papersize_desc.add(new SSTRING(MSG_R(M_PAPERTYPENOTE)));

    dump_here.f_papersize.add(new SSTRING("11x17"));
    dump_here.f_papersize.add(new SSTRING("a0"));
    dump_here.f_papersize.add(new SSTRING("a1"));
    dump_here.f_papersize.add(new SSTRING("a2"));
    dump_here.f_papersize.add(new SSTRING("a3"));
    dump_here.f_papersize.add(new SSTRING("a4"));
    dump_here.f_papersize.add(new SSTRING("a5"));
    dump_here.f_papersize.add(new SSTRING("a6"));
    dump_here.f_papersize.add(new SSTRING("a7"));
    dump_here.f_papersize.add(new SSTRING("a8"));
    dump_here.f_papersize.add(new SSTRING("a9"));
    dump_here.f_papersize.add(new SSTRING("a10"));
    dump_here.f_papersize.add(new SSTRING("archA"));
    dump_here.f_papersize.add(new SSTRING("archB"));
    dump_here.f_papersize.add(new SSTRING("archC"));
    dump_here.f_papersize.add(new SSTRING("archD"));
    dump_here.f_papersize.add(new SSTRING("archE"));
    dump_here.f_papersize.add(new SSTRING("b0"));
    dump_here.f_papersize.add(new SSTRING("b1"));
    dump_here.f_papersize.add(new SSTRING("b2"));
    dump_here.f_papersize.add(new SSTRING("b3"));
    dump_here.f_papersize.add(new SSTRING("b4"));
    dump_here.f_papersize.add(new SSTRING("b5"));
    dump_here.f_papersize.add(new SSTRING("flsa"));
    dump_here.f_papersize.add(new SSTRING("flse"));
    dump_here.f_papersize.add(new SSTRING("halfletter"));
    dump_here.f_papersize.add(new SSTRING("ledger"));
    dump_here.f_papersize.add(new SSTRING("legal"));
    dump_here.f_papersize.add(new SSTRING("letter"));
    dump_here.f_papersize.add(new SSTRING("note"));
}

/* type_printr may be:
    PRT_LOCAL
    PRT_REMOTE
    PRT_SMBWIN
    PRT_NETWARE
    PRT_DIRECT

    printer_name may be:
    'lp'
    'lp2|blah'
    etc etc (NO spaces allowed)

    my_fullspoolpath may be:
    '/var/spool/lpd/lp5'
    etc etc (the latter level directory will be created automatically)
*/
/* returns -1 if error, or the number assigned to the printer (0 to N-1),
 the number IS NOT always the last one.
 -> once a printer was added you CAN'T count on the previous
 printers' list, you must reload it */
/* this function may open a window by its own if the my_fullspoolpath
 can't be created (already exists or there's some other problem) */
/* will save the configuration file automatically with the default values */
int gi_create_a_printer(char type_printr, char *printer_name, char *my_fullspoolpath)
{
    return(return_virtual_printer_number(create_a_printer(type_printr, printer_name, my_fullspoolpath)));
}

/* remove (it's up to you to ask user for confirmation) */
/* will save configuration file automatically */
void gi_remove_printer(int which_printer_v)
{
    int which_printer;
    which_printer=translate_printer_number(which_printer_v);

    remove_printer(which_printer);
    save_all_printers_data(); // save printcap
}

void gi_init(void)
{
    kind_of_lpr_system_installed=return_lpr_system_installed_in_this_system();
    load_printcap();
}

void gi_close(void)
{
    /* nothing currently */

}


