/*
        linuxinfo_m68k.c

        Copyright (C) 1998-2000
        All Rights Reserved.

        Alex Buell <alex.buell@tahallah.demon.co.uk>

        Advanced Buell Software Engineering Ltd
        Hampshire, GU31 5DG
        United Kingdom

        Version Author  Date            Comments
        ----------------------------------------------------------------------
        1.0.0   AIB     199803??        Initial development
	1.0.1	AIB	20000405	Rework of code

        This is the m68k port of linuxinfo
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "linuxinfo.h"

#ifdef system_m68k

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	int processors = 0; 
	float bogomips = 0.0;
	float tempbogo;
	LONGLONG memory = 0;

	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char chip[BUFSIZ] = "Unknown";

	FILE *procfile;
	struct stat st_buf;

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		splitstring(temp_string, temp_string2);

		if (processors == 0)
                	if (!(strcmp(temp_string, "CP")))
				strcpy(chip, temp_string2);

		if (!(strcmp(temp_string, "ClockIn")))
			strcpy(hw->hw_megahertz, temp_string2);

                if (!(strcmp(temp_string, "BogoMip")))
                {
                        processors++;
                        sscanf(temp_string2, "%f", &tempbogo);
                        bogomips += tempbogo;
                }
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;

	sprintf(hw->hw_cpuinfo, "%s", chip);
	sprintf(hw->hw_bogomips, "%0.2f", bogomips);
}
#endif /* system_m68k */
