/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

/* Yee ole show usage function.  Put it here because I didn't feel like having a separate object for 
 * this one dinky little function, and it's related to getopt, because it'll be called from the
 * lt_getopts() function if ever */
void lt_sh_usage()
{

  PRINT_VERSION;
  printf ("\n");
  printf("Command line options:\n");
  printf(" -c [/path/config.file] = specify a config file other than %s\n", CONFIG_FILE);
  printf(" -o [ ANSI | ASCII | CSV | HTML | RAW ]\n  Output Format: ANSI (default), ASCII, CSV, HTML, RAW\n");
  printf(" -t [ long | short ]\n\tTime display Format: (Long [default]) Mon Dy HH:MM:SS or (Short) HH:MM\n");
  printf(" -b = beep on RED events (ANSI output only)\n");
  printf(" -s = do not display the syslog \"source\" field\n");
  printf(" -p = do not display the \"program\" field\n");
  printf(" -i includefile\n\tFile containing regex's for inclusion [default=%s]\n", INCLUDEFILE);
  printf(" -e excludefile\n\tFile containing regex's for exclusion [default=%s]\n", EXCLUDEFILE);
  printf(" -y yellowfile\n\tFile containing regex's for yellow colorization [default=%s]\n", YELLOWFILE);
  printf(" -g greenfile\n\tFile containing regex's for green colorization [default=%s]\n", GREENFILE);
  printf(" -v or = verbose (does nothing currently)\n");
  printf(" -V or = print version and exit \n");
  printf(" -h or = this help message\n");
}


void lt_getopts(int argc, char **argv)
{
	

	int option;
	
/* 
 * Set the defaults for what/how to parse (they may be changed below, but 
 * they'll at least have to be SOMETHING... 
 */

  /* Set the options to something sane before we accept any user defined options	*/
  outfmt = OUTPUT_ANSI;			/* ANSI is the default output type 		*/
  showprog = TRUE;			/* set this to true by default			*/
  verbose = FALSE;			/* We are not verbose by default 		*/
  redbeep = FALSE;			/* We do not beep on red events by default 	*/
  timefmt = DATE_LONG;
  showsrc = TRUE;
  strncpy(configfile, CONFIG_FILE, 1023);
  redbeep = FALSE; 
  
  /* Read the default config file for our user defined defaults				*/
  lt_read_config();
  
  /* Check out the command line options 						*/
  while ((option = getopt(argc, argv, OPTIONS)) != -1)
    {
      switch (option)
        {
        case 0:         /* I dunno why this is here; was there in the example so I left it... */
     		break; 
  	
	case 'h':
		lt_sh_usage();
		exit(0);
		break;
	
	case 'c':
		strncpy(configfile, optarg, 1023);
		lt_read_config();
		break;
		
	case 't':
	  	if(strncasecmp(optarg, "long", 32) == 0) {
			timefmt = DATE_LONG;
		} else if(strncasecmp(optarg, "short", 32) == 0) {
			timefmt = DATE_SHORT;
		} else {
			lt_sh_usage();
			exit(0);
		}
		break;
				
	  
	case 's':
	  	showsrc = FALSE;
		break;
	
	case 'p':
	  	showprog = FALSE;
		break;
  	case 'o':
		if(strncasecmp(optarg, "ansi", 32) == 0) {
                	outfmt = OUTPUT_ANSI;
		} else if(strncasecmp(optarg, "ascii", 32) == 0) {
                	outfmt = OUTPUT_ASCII;
		} else if(strncasecmp(optarg, "csv", 32) == 0) {
                	outfmt = OUTPUT_CSV;
		} else if(strncasecmp(optarg, "html", 32) == 0) {
                	outfmt = OUTPUT_HTML;
		} else if(strncasecmp(optarg, "raw", 32) == 0) {
			outfmt = OUTPUT_RAW;
		} else {
                        lt_sh_usage();
                        exit(1);
                }
          break;

        case 'b':
          redbeep = TRUE;
          break;

        case 'i':
          strncpy(includefile, optarg, 254);
	  checks.include = TRUE;
          break;

        case 'e':
          strncpy(excludefile, optarg, 254);
          break;

        case 'y':
          strncpy(yellowfile, optarg, 254);
          break;

        case 'g':
          strncpy(greenfile, optarg, 254);
          break;

        case 'v':
	  verbose = 1;
          break;
        case 'V':

          PRINT_VERSION;        /* put version stuff to screen */
          exit (0);             /* exit with errlevel 0 */
          break;                /* why is this here?  I dunno... */
        default:
          lt_sh_usage();
          exit (1);             /* some sucker done put in invalid cmdline options ... grrr... */

        }
    }
}

