/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

/* The function that parses the line.  It's pretty basic at this point,
 * but in the future, it will do a lot more to the data */
int lt_do_parse() {
	
	int ok = TRUE;
	
	sscanf(event.raw, "%s %s %s %s %s %[^\n]", 
			event.month, event.day, event.time, event.source, event.program, event.message);
	
	if(checks.include == TRUE && lt_match(event.raw, includestrings) != TRUE) {
		ok = FALSE;
	}
	if(checks.exclude == TRUE && lt_match(event.raw, excludestrings) == TRUE) {
		ok = FALSE;
	}
		
	
	return (ok);	
}

void lt_set_event_color() {

        strncpy(event.pcolor, color.red, 255); /* set color == red by default */

	if(checks.yellow == TRUE && lt_match(event.raw, yellowstrings) != 0) {
		strncpy(event.pcolor, color.yellow, 255);        /* yellow event color */
        } else  if(checks.green == TRUE && lt_match(event.raw, greenstrings) != 0) {
                strncpy(event.pcolor, color.green, 255);         /* green event color */
        }
}
