#include <stdlib.h>
#include <string.h>

#include "fragment.h"

struct fragment *frag_new() {
	struct fragment *f;

	f = malloc(sizeof(*f));
	memset(f, 0, sizeof(*f));
	return f;
}

void frag_free(struct fragment *f) {
	if(f->true)
		free(f->true);
	if(f->false)
		free(f->false);
	if(f->insns)
		free(f->insns);
	if(f->ftrue)
		free(f->ftrue);
	if(f->tfalse)
		free(f->tfalse);
	free(f);
}

void frag_fixupt(struct fragment *f, int dest) {
	int i, insn;

	if(f->numtrue) {
		for(i = 0; i < f->numtrue; i++) {
			insn = f->true[i];
			f->insns[insn].jt = f->numinsns + dest - insn - 1;
		}
		free(f->true);
		f->true = NULL;
		f->numtrue = 0;
	}
	if(f->numftrue) {
		for(i = 0; i < f->numftrue; i++) {
			insn = f->ftrue[i];
			f->insns[insn].jf = f->numinsns + dest - insn - 1;
		}
		free(f->ftrue);
		f->ftrue = NULL;
		f->numftrue = 0;
	}
}

void frag_fixupf(struct fragment *f, int dest) {
	int i, insn;

	if(f->numfalse) {
		for(i = 0; i < f->numfalse; i++) {
			insn = f->false[i];
			f->insns[insn].jf = f->numinsns + dest - insn - 1;
		}
		free(f->false);
		f->false = NULL;
		f->numfalse = 0;
	}
	if(f->numtfalse) {
		for(i = 0; i < f->numtfalse; i++) {
			insn = f->tfalse[i];
			f->insns[insn].jt = f->numinsns + dest - insn - 1;
		}
		free(f->tfalse);
		f->tfalse = NULL;
		f->numtfalse = 0;
	}
}

void frag_append(struct fragment *f, struct fragment *g) {
	int newlen, newt, newf, newft, newtf, i;

	if(!f || !g)
		return;
	newlen = f->numinsns + g->numinsns;
	newt = f->numtrue + g->numtrue;
	newf = f->numfalse + g->numfalse;
	newft = f->numftrue + g->numftrue;
	newtf = f->numtfalse + g->numtfalse;
	f->insns = realloc(f->insns, newlen * sizeof(*f->insns));
	for(i = 0; i < g->numinsns; i++)
		f->insns[i + f->numinsns] = g->insns[i];
	if(newt)
		f->true = realloc(f->true, newt * sizeof(*f->true));
	for(i = 0; i < g->numtrue; i++)
		f->true[i + f->numtrue] = g->true[i] + f->numinsns;
	if(newft)
		f->ftrue = realloc(f->ftrue, newft * sizeof(*f->ftrue));
	for(i = 0; i < g->numftrue; i++)
		f->ftrue[i + f->numftrue] = g->ftrue[i] + f->numinsns;
	if(newf)
		f->false = realloc(f->false, newf * sizeof(*f->false));
	for(i = 0; i < g->numfalse; i++)
		f->false[i + f->numfalse] = g->false[i] + f->numinsns;
	if(newtf)
		f->tfalse = realloc(f->tfalse, newtf * sizeof(*f->tfalse));
	for(i = 0; i < g->numtfalse; i++)
		f->tfalse[i + f->numtfalse] = g->tfalse[i] + f->numinsns;
	f->numinsns = newlen;
	f->numtrue = newt;
	f->numfalse = newf;
	f->numftrue = newft;
	f->numtfalse = newtf;
}

void frag_add(struct fragment *f, struct bpf_insn *i) {
	f->insns = realloc(f->insns, ++f->numinsns * sizeof(*f->insns));
	f->insns[f->numinsns - 1] = *i;
}

void frag_sett(struct fragment *f) {
	f->true = realloc(f->true, ++f->numtrue * sizeof(*f->true));
	f->true[f->numtrue - 1] = f->numinsns - 1;
}

void frag_setf(struct fragment *f) {
	f->false = realloc(f->false, ++f->numfalse * sizeof(*f->false));
	f->false[f->numfalse - 1] = f->numinsns - 1;
}

void frag_setft(struct fragment *f) {
	f->ftrue = realloc(f->ftrue, ++f->numftrue * sizeof(*f->ftrue));
	f->ftrue[f->numftrue - 1] = f->numinsns - 1;
}

void frag_settf(struct fragment *f) {
	f->tfalse = realloc(f->tfalse, ++f->numtfalse * sizeof(*f->tfalse));
	f->tfalse[f->numtfalse - 1] = f->numinsns - 1;
}
