#ifndef _GNET_PROTO_H_
#define _GNET_PROTO_H_

#include <stdint.h>
#include <endian.h>
#include <byteswap.h>

#if __BYTE_ORDER == __LITTLE_ENDIAN

#define GTOHS(x)	(x)
#define GTOHL(x)	(x)
#define HTOGS(x)	(x)
#define HTOGL(x)	(x)

#else

#define GTOHS(x)	bswap_16(x)
#define GTOHL(x)	bswap_32(x)
#define HTOGS(x)	bswap_16(x)
#define HTOGL(x)	bswap_32(x)

#endif

#define GNET_MSG_PING	0x00
#define GNET_MSG_PONG	0x01
#define GNET_MSG_BYE	0x02
#define GNET_MSG_VENDOR	0x31
#define GNET_MSG_STDEXT	0x32
#define GNET_MSG_PUSH	0x40
#define GNET_MSG_QUERY	0x80
#define GNET_MSG_QHITS	0x81

#define GNET_FIELD_ID	0x00
#define GNET_FIELD_TYPE	0x10
#define GNET_FIELD_TTL	0x11
#define GNET_FIELD_HOPS	0x12
#define GNET_FIELD_SIZE	0x13

#define GNET_ID(x)	((unsigned char*)x + GNET_FIELD_ID)
#define GNET_TYPE(x)	(*((uint8_t*)x + GNET_FIELD_TYPE))
#define GNET_TTL(x)	(*((uint8_t*)x + GNET_FIELD_TTL))
#define GNET_HOPS(x)	(*((uint8_t*)x + GNET_FIELD_HOPS))
#define GNET_SIZE(x)	GTOHL(*(uint32_t*)((char*)x + GNET_FIELD_SIZE))

#define GNET_HDR_SIZE	23
#define GNET_PONG_SIZE	14

int gnet_handle_message(struct gnet*, struct channel*);

#endif
