#line 2 "info.c"
/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: info.c,v 1.97 2002/02/03 11:13:41 dolecek Exp $ */

#include "csacek.h"
#include "csa_version.h"

#ifdef CSA_WANT_INFO
static const char *x_htmlify __P((const char *, char *));

/*
 * substitutes all occurences of > with &gt; and < with &lt;
 */
static const char *
x_htmlify(what, buff)
  const char *what;
  char *buff;
{
	const char *orig_buff=buff;
	size_t len;

	while(*what) {
		len = strcspn(what, "<>");
		if (len > 0) {
			strncpy(buff, what, len);
			what += len;
			buff += len;
		}

		if (*what == '>') strncpy(buff, "&gt;", 4);
		else if (*what == '<') strncpy(buff, "&lt;", 4);
		else
			continue;
		what++;
		buff += 4;
	}
	*buff = '\0';
	return orig_buff;
}

/*
 * generate report page about compiled-in defaults 
 */
int 
csa_info(p, cfg)
  csa_params_t *p;
  const csa_conf_t *cfg;
{
	char buf[2048], buf2[2048];
	size_t len;

#ifdef CSA_DEBUG
	csa_debug(p->dbg, "csa_info: called");
#endif

	csa_setheaderout(p, "Status", "200 OK", 0);
	csa_setheaderout(p, "Content-Type", "text/html", 0);

	len = sprintf(buf, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
	csa_add_output(p, buf, len, 0);

        len = sprintf(buf, "<HTML>\n<HEAD>\n<TITLE>CSaCzech %s report</TITLE>\n",
                        CSA_VERSION);
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<META HTTP-Equiv=\"Content-Type\" Content=\"text/html; charset=iso-8859-1\">\n");
	csa_add_output(p, buf, len, 0);

	csa_add_output(p, "</HEAD><BODY>\n", 0, CSA_OUT_STR);

	len = sprintf(buf, "<H3><A HREF=\"http://www.csacek.cz/\">CSaCzech %s</A> (c) 1996-2001 <a href=\"http://www.ics.muni.cz/~dolecek/\">Jaromir Dolecek</a></H3>\n", CSA_VERSION );
	csa_add_output(p, buf, len, 0);

# ifdef CSA_DEBUG
	csa_add_output(p, "This is <STRONG>DEBUG</STRONG> version.<BR>\n",
		0, CSA_OUT_STR);
#endif /* CSA_DEBUG */
	len = sprintf(buf,"This version has been compiled on <TT>%s</TT> (%s) as %s.\n",
		CSA_SYSTEM_TYPE, CSA_OS_TYPE, CSA_MUTACE_NAME);
	csa_add_output(p, buf, len, 0);

	/* CSacek configuration */
	csa_add_output(p, "<H4>Configuration:</H4>\n", 0, CSA_OUT_STR);

	len = sprintf(buf, "<EM>Compression</EM>: <TT>%s</TT><BR>\n",
		(CSA_ISSET(cfg->flags, CSA_CFG_COMPRESS))
			? "enabled" : "disabled");
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<EM>Default source encoding</EM>: <TT>%s</TT><BR>\n", 
		cfg->DefaultCharset);
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<EM>TemplateDir</EM>: <TT>%s</TT><BR>\n",
		cfg->TemplateDir);
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<EM>IgnorePrefix</EM>: <TT>%s</TT><BR>\n",
		p->ignoreprefix->value);
	csa_add_output(p, buf, len, 0);	

	len = sprintf(buf, "<EM>Default part</EM>: <TT>%s</TT><BR>\n",
		cfg->DefaultPartname);
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<EM>Default BAR settings</EM>: <TT>%s</TT><BR>\n",
		(cfg->BarDef) ?  x_htmlify(cfg->BarDef, buf2)
			: "(not specified)");
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "<EM>URL rewriting</EM>: <TT>%s</TT><BR>\n",
		(CSA_ISSET(cfg->flags, CSA_CFG_CHANGEURL)) ? "on" : "off");
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf,
		"<EM>Recoding client data to <TT>%s</TT></EM>: <TT>%s</TT><BR>\n",
		cfg->DefaultCharset,
		(CSA_ISSET(cfg->flags, CSA_CFG_RECODEINPUT)) ? "on" : "off");
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf,
		"<EM>Implicit work</EM>: <TT>%s</TT><BR>\n",
		(CSA_ISSET(cfg->flags, CSA_CFG_IMPLICITWORK)) ? "on" : "off");
	csa_add_output(p, buf, len, 0);

	/* list of CSacek servers */
	csa_add_output(p, "<EM>Registered CSacek servers</EM>:\n",
		0, CSA_OUT_STR);
	csa_slist_dump(p);

	/* BAR settings */
	csa_add_output(p, "<H4>BAR settings:</H4>\n", 0, CSA_OUT_STR);

#ifdef CSA_ALWAYSADDBAR
	csa_add_output(p, "<TT>BAR</TT> is automagically added on the end of any HTML page.<BR>\n", 0, CSA_OUT_STR);
#endif

	len = sprintf(buf,
		"Names of codes in bar are %s by&nbsp;default.<BR>\n",
#ifndef CSA_LONGNAMEBAR
		"long"
#else
		"short"
#endif
	);
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,
		"<EM>HTML code at head of the czech bar</EM>: <TT>%s</TT><BR>", 
		x_htmlify(CSA_HEADBARTEXT, buf2));
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,
		"<EM>HTML code at head of the english bar</EM>: <TT>%s</TT><BR>\n",
		x_htmlify(CSA_EHEADBARTEXT, buf2));
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,
		"<EM>HTML code at end of czech bar is:</EM> <TT>%s</TT><BR>\n",
		x_htmlify(CSA_TAILBARTEXT, buf2));
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,"<EM>HTML code at end of english bar</EM>: <TT>%s</TT><BR>\n",
		x_htmlify(CSA_ETAILBARTEXT, buf2));
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,
		"Link to whichcode is%s added to bar by default.<BR>\n",
#  ifdef CSA_ADDWHICHCODE
		""
#  else
		"n't"
#  endif
	);
	csa_add_output(p, buf, len, 0);
	len = sprintf(buf,
		"Name of whichcode option in a bar is '<TT>%s</TT>' by default.<BR>\n",
#  ifdef CSA_BARWHICHCODENAME
		CSA_BARWHICHCODENAME
#  else
		"[none]"
#  endif
	);
	csa_add_output(p, buf, len, 0);

	/* other settings */
	csa_add_output(p, "<P><H4>Other settings:</H4>\n", 0, CSA_OUT_STR);

#ifdef CSA_MUTACE_XCGI
	len = sprintf(buf, "Documents with following suffixes will be coded by method \"file\": <EM>%s</EM>.<BR>\n", CSA_CONVERT_SUFFIXES);
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "Suffixes <EM>\"%s\"</EM> are ignored in name of CSacek script and won't ever be&nbsp;a partname.<BR>\n", CSA_IGNORE_SUFFIXES );
	csa_add_output(p, buf, len, 0);

	len = sprintf(buf, "Getmethod is '%s'.<BR>\n", 
# if CSA_METHOD_HTTP
		"http"
# elif CSA_METHOD_FILE
		"file"
# elif CSA_METHOD_GUESS
		"guess"
# else
		"unknown"
# endif
	);
	csa_add_output(p, buf, len, 0);
#endif /* CSA_MUTACE_XCGI */

	len = sprintf(buf,
	"The character which marks C-SaCzech commands is '<TT>%c</TT>'.<BR>\n",
		CSA_CMD_TAG);
	csa_add_output(p, buf, len, 0);

#ifdef CSA_MUTACE_XCGI
	len = sprintf( buf, "Security: %s%s.<BR>\n",
# ifdef CSA_WANT_SECURE
		"I DO care about it; I look for files '.htaccess' & ",
		"'.nsconfig' on path to accessed document."
# else
		"I do NOT care about this", ""
# endif
	);
	csa_add_output(p, buf, len, 0);
#endif /* CSA_MUTACE_(FAST)CGI */

#ifdef CSA_CANONIFY_DIRURL
	csa_add_output(p, "If requested URL leads to dir and doesn't end with <TT>/</TT>, I redirect client to&nbsp;the&nbsp;right one.<BR>\n", 0, CSA_OUT_STR);
#endif

	csa_add_output(p, "<TT>__LAMPACHARSET__</TT> is substituted by&nbsp;name of&nbsp;target encoding\nin&nbsp;form used by&nbsp;Lampa's Apache czech module.<BR>\n",
		0, CSA_OUT_STR);

#ifdef CSA_COMPAT_13X
	csa_add_output(p, "I try to be compatible with&nbsp;older (pre 1.3.3) versions of C-SaCzech;\nolder syntax of <TT>PART, DOMAIN</TT> and <TT>BAR</TT> would work.<BR>\n", 0, CSA_OUT_STR);
#endif

#ifdef CSA_WANT_BANNER
	csa_add_output(p, "I write short banner at the start of any recoded HTML page to mark that it has been recoded by CSacek.\n", 0, CSA_OUT_STR);
#endif

	/* We are proud HTML 4.01 validated */
	csa_add_output(p, "<p>\
    <a href=\"http://validator.w3.org/check/referer\"><img border=\"0\"
        src=\"http://www.w3.org/Icons/valid-html401\"
        alt=\"Valid HTML 4.01!\" height=\"31\" width=\"88\"></a>
  </p>\n", 0, CSA_OUT_STR);

	csa_add_output(p, "</BODY>\n</HTML>", 0, CSA_OUT_STR);

	return CSA_INFO;
} /* csa_report */
#endif /* CSA_WANT_INFO */

void 
csa_version()
{
	printf("C-SaCzech %s %s\nCopyright (c) 1996-2001 Jaromir Dolecek <dolecek@ics.muni.cz>\n", CSA_VERSION,
#ifdef CSA_DEBUG
		"(DEBUG)"
#else
		""
#endif /* CSA_DEBUG */
		 );
	printf("	Built on: %s, %s\n", CSA_OS_TYPE, CSA_SYSTEM_TYPE);
}
