/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NamespaceNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.value.UntypedAtomicValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Node node;
    private int namecode = -1;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Node node, NodeWrapper nodeWrapper, int n) {
        this.node = node;
        this.parent = nodeWrapper;
        this.index = n;
    }

    public NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        return this.makeWrapper(node, documentWrapper, null, -1);
    }

    public NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        switch (node.getNodeType()) {
            case 9: {
                return documentWrapper;
            }
            case 1: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = 1;
                break;
            }
            case 2: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)2;
                break;
            }
            case 3: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 4: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 8: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)8;
                break;
            }
            case 7: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValue()));
    }

    public int getTypeAnnotation() {
        return 0;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        return this.getSiblingPosition() == nodeWrapper.getSiblingPosition() && this.getParent().isSameNode(nodeWrapper.getParent());
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        NodeInfo nodeInfo = this;
        if (this.getNodeKind() != 1) {
            nodeInfo = this.getParent();
        }
        while (nodeInfo != null) {
            String string = nodeInfo.getAttributeValue(385);
            if (string == null) continue;
            return string;
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        return Navigator.compareOrder(this, (SiblingCountingNode)nodeInfo);
    }

    public String getStringValue() {
        return NodeWrapper.getStringValue(this.node, this.nodeKind);
    }

    public static String getStringValue(Node node, int n) {
        switch (n) {
            case 1: 
            case 9: {
                NodeList nodeList = node.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer();
                NodeWrapper.expandStringValue(nodeList, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: {
                return node.getNodeValue();
            }
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return "";
    }

    private static void expandStringValue(NodeList nodeList, StringBuffer stringBuffer) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 1: {
                    NodeWrapper.expandStringValue(node.getChildNodes(), stringBuffer);
                    break;
                }
                default: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
            ++n;
        }
    }

    public int getNameCode() {
        if (this.namecode != -1) {
            return this.namecode;
        }
        NodeWrapper nodeWrapper = this;
        switch (this.nodeKind) {
            case 2: {
                nodeWrapper = this.parent;
            }
            case 1: {
                NodeInfo nodeInfo;
                String[] stringArray;
                if (this.node.getNamespaceURI() != null) {
                    String string = this.node.getPrefix();
                    if (string == null) {
                        string = "";
                    }
                    this.namecode = this.docWrapper.namePool.allocate(string, this.node.getNamespaceURI(), this.node.getLocalName());
                    return this.namecode;
                }
                try {
                    stringArray = Name.getQNameParts(this.node.getNodeName());
                }
                catch (QNameException qNameException) {
                    throw new IllegalStateException("Invalid QName in DOM node. " + qNameException);
                }
                String string = null;
                AxisIterator axisIterator = nodeWrapper.iterateAxis((byte)8);
                while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                    if (!nodeInfo.getLocalPart().equals(stringArray[0])) continue;
                    string = nodeInfo.getStringValue();
                }
                if (string == null) {
                    if (stringArray[0].equals("")) {
                        string = "";
                    } else {
                        throw new IllegalStateException("Undeclared namespace prefix in DOM input: " + stringArray[0]);
                    }
                }
                this.namecode = this.docWrapper.namePool.allocate(stringArray[0], string, stringArray[1]);
                return this.namecode;
            }
            case 7: {
                this.namecode = this.docWrapper.namePool.allocate("", "", this.getDisplayName());
                return this.namecode;
            }
        }
        return -1;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        String string = this.node.getLocalName();
        if (string == null) {
            String string2 = this.getDisplayName();
            int n = string2.indexOf(58);
            if (n >= 0) {
                return string2.substring(n + 1);
            }
            return string2;
        }
        return string;
    }

    public String getURI() {
        String string = this.node.getNamespaceURI();
        if (string == null) {
            if (this.node.getNodeName().startsWith("xml:")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }
        return string;
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.node.getNodeName();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            switch (this.getNodeKind()) {
                case 2: {
                    this.parent = this.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                    break;
                }
                default: {
                    Node node = this.node.getParentNode();
                    if (node == null) {
                        return null;
                    }
                    this.parent = this.makeWrapper(this.node.getParentNode(), this.docWrapper);
                }
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    int n = 0;
                    Node node = this.node;
                    while (true) {
                        if ((node = node.getPreviousSibling()) == null) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
                case 2: {
                    int n = 0;
                    int n2 = this.getFingerprint();
                    AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
                    while (true) {
                        NodeInfo nodeInfo;
                        if ((nodeInfo = (NodeInfo)axisIterator.next()) == null || nodeInfo.getFingerprint() == n2) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
                case 13: {
                    int n = 0;
                    int n3 = this.getFingerprint();
                    AxisIterator axisIterator = this.parent.iterateAxis((byte)8);
                    while (true) {
                        NodeInfo nodeInfo;
                        if ((nodeInfo = (NodeInfo)axisIterator.next()) == null || nodeInfo.getFingerprint() == n3) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
            }
            this.index = 0;
            return this.index;
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AncestorEnumeration(this, false);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AncestorEnumeration(this, true);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new ChildEnumeration(this, true, true);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.DescendantEnumeration(this, false, true);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.DescendantEnumeration(this, true, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration(this);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, true);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceEnumeration(this);
            }
            case 9: {
                this.getParent();
                return SingletonIterator.makeIterator(this.parent);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration(this, false);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, false);
            }
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration(this, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(by), nodeTest);
    }

    public String getAttributeValue(int n) {
        NameTest nameTest = new NameTest(2, n);
        AxisIterator axisIterator = this.iterateAxis((byte)2, nameTest);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (nodeInfo == null) {
            return null;
        }
        return nodeInfo.getStringValue();
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        if (this.node instanceof Attr) {
            return false;
        }
        return this.node.hasChildNodes();
    }

    public String generateId() {
        return Navigator.getSequentialKey(this);
    }

    public int getDocumentNumber() {
        return this.parent.getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        Navigator.copy(this, receiver, this.docWrapper.namePool, n, bl);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws TransformerException {
        if (this.nodeKind == 1) {
            NamespaceNode namespaceNode;
            NamePool namePool = this.docWrapper.getNamePool();
            AxisIterator axisIterator = this.iterateAxis((byte)8);
            while ((namespaceNode = (NamespaceNode)axisIterator.next()) != null && (bl || namespaceNode.getParent().isSameNode(this))) {
                int n = namePool.allocateNamespaceCode(namespaceNode.getDisplayName(), namespaceNode.getStringValue());
                receiver.namespace(n, 0);
            }
        }
    }

    private final class ChildEnumeration
    extends AxisIteratorImpl
    implements LookaheadIterator {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ArrayList items = new ArrayList();
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.position = 0;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            NodeList nodeList = this.commonParent.node.getChildNodes();
            if (bl) {
                if (!bl2) {
                    this.ix = nodeList.getLength() - 1;
                }
            } else {
                this.ix = nodeWrapper2.getSiblingPosition() + (bl2 ? 1 : -1);
            }
            if (bl2) {
                int n = this.ix;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    switch (node.getNodeType()) {
                        case 10: {
                            break;
                        }
                        default: {
                            if (this.isAtomizing()) {
                                this.items.add(new UntypedAtomicValue(NodeWrapper.getStringValue(node, node.getNodeType())));
                                break;
                            }
                            this.items.add(NodeWrapper.this.makeWrapper(node, NodeWrapper.this.docWrapper, this.commonParent, n));
                        }
                    }
                    ++n;
                }
            } else {
                int n = this.ix;
                while (n >= 0) {
                    Node node = nodeList.item(n);
                    switch (node.getNodeType()) {
                        case 10: {
                            break;
                        }
                        default: {
                            if (this.isAtomizing()) {
                                this.items.add(new UntypedAtomicValue(NodeWrapper.getStringValue(node, node.getNodeType())));
                                break;
                            }
                            this.items.add(NodeWrapper.this.makeWrapper(node, NodeWrapper.this.docWrapper, this.commonParent, n));
                        }
                    }
                    --n;
                }
            }
        }

        public boolean hasNext() {
            return this.position < this.items.size();
        }

        public Item next() {
            if (this.position < this.items.size()) {
                this.current = (Item)this.items.get(this.position++);
                return this.current;
            }
            return null;
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class NamespaceEnumeration
    extends AxisIteratorImpl
    implements LookaheadIterator {
        private HashMap nslist = new HashMap();
        private Iterator prefixes;
        private NodeWrapper start;

        public NamespaceEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            NodeWrapper nodeWrapper3 = nodeWrapper2;
            do {
                Element element = (Element)nodeWrapper3.node;
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    String string;
                    Attr attr = (Attr)namedNodeMap.item(n);
                    String string2 = attr.getName();
                    if (string2.equals("xmlns")) {
                        if (!this.nslist.containsKey("")) {
                            this.nslist.put("", new NamespaceNode(nodeWrapper2, "", attr.getValue()));
                        }
                    } else if (string2.startsWith("xmlns:") && !this.nslist.containsKey(string = string2.substring(6))) {
                        this.nslist.put(string, new NamespaceNode(nodeWrapper2, string, attr.getValue()));
                    }
                    ++n;
                }
            } while ((nodeWrapper3 = (NodeWrapper)nodeWrapper3.getParent()).getNodeKind() == 1);
            this.nslist.put("xml", new NamespaceNode(nodeWrapper2, "xml", "http://www.w3.org/XML/1998/namespace"));
            this.prefixes = this.nslist.keySet().iterator();
        }

        public boolean hasNext() {
            return this.prefixes.hasNext();
        }

        public Item next() {
            if (this.prefixes.hasNext()) {
                String string = (String)this.prefixes.next();
                this.current = (NamespaceNode)this.nslist.get(string);
                ++this.position;
                return this.current;
            }
            return null;
        }

        public SequenceIterator getAnother() {
            return new NamespaceEnumeration(this.start);
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private ArrayList attList = new ArrayList();
        private int ix = 0;
        private NodeWrapper start;
        private NodeWrapper current;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            NamedNodeMap namedNodeMap = nodeWrapper2.node.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                String string = namedNodeMap.item(n).getNodeName();
                if (!string.startsWith("xmlns") || string.length() != 5 && string.charAt(5) != ':') {
                    this.attList.add(namedNodeMap.item(n));
                }
                ++n;
            }
            this.ix = 0;
        }

        public boolean hasNext() {
            return this.ix < this.attList.size();
        }

        public Item next() {
            if (this.ix >= this.attList.size()) {
                return null;
            }
            this.current = this.start.makeWrapper((Attr)this.attList.get(this.ix), NodeWrapper.this.docWrapper, this.start, this.ix);
            ++this.ix;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.ix + 1;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

