
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libcdg123.h"

int cdgProcessChunk(struct cdgStream *stream, struct cdgSubChannelChunk *chunk)
{

	if((chunk->command & SC_MASK) != SC_CDG_COMMAND) return -1 ;

	switch(chunk->instruction & SC_MASK) {

		case CDG_MEMORYPRESET:
			return cdgMemoryPreset(stream, chunk->data) ;
			break ;
		case CDG_BORDERPRESET:
			return cdgBorderPreset(stream, chunk->data) ;
			break ;
		case CDG_TILEBLOCKNORMAL:
			return cdgTileBlockNormal(stream, chunk->data) ;
			break ;
		case CDG_SCROLLPRESET:
			return cdgScrollPreset(stream, chunk->data) ;
			break ;
		case CDG_SCROLLCOPY:
/*			return cdgScrollCopy(stream, chunk->data) ; */
			break ;
		case CDG_TRANSPARENTCOLOR:
			return cdgTransparentColor(stream, chunk->data) ;
			break ;
		case CDG_COLORTABLELO:
			return cdgLoadColorTable(stream, chunk->data, 0) ;
			break ;
		case CDG_COLORTABLEUP:
			return cdgLoadColorTable(stream, chunk->data, 8) ;
			break ;
		case CDG_TILEBLOCKXOR:
			return cdgTileBlockXOR(stream, chunk->data) ;
			break ;
		default:
			return 128 ;
			break ;
	}
}

int cdgGetRGBAFrame(struct cdgStream *stream, unsigned char *RGBABuffer) {

	return cdgFrameToRGBA(stream,RGBABuffer) ;

}

int cdgDriveCapable(char *drive)
{
	return cdgCheckDrive(drive) ;
}

int cdgIdChunk(struct cdgSubChannelChunk *chunk)
{
	if((chunk->command & SC_MASK) != SC_CDG_COMMAND) return -1 ;

	return chunk->instruction & SC_MASK ;
}

int cdgInitStream(struct cdgStream *stream) {

	memset(stream,0,sizeof(struct cdgStream)) ;
	stream->borderColor = 16 ;
	stream->transparentColor = 16 ;

}

int cdgInitRGBA(char *RGBABuffer) {

	memset(RGBABuffer,0,CDG_RGBAFRAMESIZE) ;

}
