
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)                     
#include <Common.hpp>
#endif

#if   !defined(__NAMEIDENTIFIER_HPP)
#include <NameIdentifier.hpp>
#endif

using namespace corelinux;

//
// Default constructor not allowed
//

NameIdentifier::NameIdentifier( void ) throw(Assertion)
   :
   Identifier(),
   theName("")
{
   NEVER_GET_HERE;  
}

//
// Instance constructor with name
//

NameIdentifier::NameIdentifier( NameCref aRef )
   :
   Identifier(),
   theName( aRef )
{
   ;  // do nothing
}

//
// Copy constructor 
//

NameIdentifier::NameIdentifier( NameIdentifierCref aRef )
   :
   Identifier(),
   theName( aRef.getName() )
{
   ;  //  do nothing
}

//
// Destructor
//

NameIdentifier::~NameIdentifier( void )
{
   ;  // do nothing
}

//
// Operator assignment not allowed
//

NameIdentifierRef NameIdentifier::operator=( NameIdentifierCref aRef )
{
   if( *this == aRef )
   {
      ;  // do nothing
   }
   else
   {
      theName = aRef.getName();
   }
   return (*this);
}

//
// Equality
//

bool  NameIdentifier::operator==( NameIdentifierCref aRef )
{
   return Identifier::operator==(aRef);
}

//
// Retrieve my name
//

NameCref    NameIdentifier::getName( void ) const
{
   return theName;
}

//
// Virtual methods overrides
//

bool  NameIdentifier::isEqual( IdentifierCref aRef ) const 
{
   NameIdentifierCptr      rhRef = dynamic_cast<NameIdentifierCptr>(&aRef);
   return (this->getName() == rhRef->getName());
}

/** 
Less than method
@param Identifier const reference
@return true if less than, false otherwise
*/

bool  NameIdentifier::isLessThan( IdentifierCref aRef ) const 
{
   NameIdentifierCptr      rhRef = dynamic_cast<NameIdentifierCptr>(&aRef);
   return (this->getName() < rhRef->getName());
}

/** 
Less than or equal method.
@param Identifier const reference
@return true if less than or equal, false otherwise
*/

bool  NameIdentifier::isLessThanOrEqual( IdentifierCref aRef ) const 
{
   NameIdentifierCptr      rhRef = dynamic_cast<NameIdentifierCptr>(&aRef);
   return (this->getName() <= rhRef->getName());
}

/** 
Greater than method.
@param Identifier const reference
@return true if greater than, false otherwise
*/

bool  NameIdentifier::isGreaterThan( IdentifierCref aRef ) const 
{
   NameIdentifierCptr      rhRef = dynamic_cast<NameIdentifierCptr>(&aRef);
   return (this->getName() > rhRef->getName());
}

/** 
Greater than or equal method.
@param Identifier const reference
@return true if greater than or equal, false otherwise
*/

bool  NameIdentifier::isGreaterThanOrEqual( IdentifierCref aRef ) const
{
   NameIdentifierCptr      rhRef = dynamic_cast<NameIdentifierCptr>(&aRef);
   return (this->getName() >= rhRef->getName());
}


/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:47:56 $
   $Locker:  $
*/

