#if   !defined( __DOOR_HPP)
#define  __DOOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAPSITE_HPP)
#include <MapSite.hpp>
#endif

enum DoorState
{
   DOOROPEN=0,
   DOORCLOSED
};


DECLARE_CLASS( Room );
DECLARE_CLASS( Door );

/**
Doors join two rooms
*/

class Door : public MapSite
{

public:

   //
   // Constructor and destructor
   //

                        /**
                        Default constructor can take one or two
                        rooms
                        @param Room pointer Room 1
                        @param Room pointer Room 2
                        */

                        Door( RoomPtr = NULLPTR, RoomPtr = NULLPTR );

                        /// Copy constructor

                        Door( DoorCref );

                        /// Virtual Destructor

   virtual              ~Door( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            DoorRef  operator=( DoorCref ) throw(CORELINUX(Assertion));

            /// Equality operator

            bool  operator==( DoorCref aRef ) const;

   //
   // Accessors
   //
            /// Is door open - true is yes

            bool  isOpen( void ) const;

            /// Is door closed - true is yes

            bool  isClosed( void ) const;

            /// Get the first room

            RoomPtr  getFirstRoom( void ) const;

            /// Get the second room

            RoomPtr  getSecondRoom( void ) const;

            /// Get the opposite room from the argument

            RoomPtr  otherSideFrom( RoomPtr ) const throw(CORELINUX(Assertion));
   //
   // Mutator
   //

            /// Opens door if closed

            void     setOpen( void );

            /// Closes door if open

            void     setClosed( void );

            /// Magical Room Change

            void     setFirstRoom( RoomPtr ) throw(CORELINUX(Assertion));

            /// Magical Room Change

            void     setSecondRoom( RoomPtr ) throw(CORELINUX(Assertion));
   //
   // Pure virtual
   //
            /**
            The one operation "enter", the meaning
            depends on the derivation, or what it
            is you are entering
            */
   
   virtual void enter( void );

private:

            RoomPtr     theFirstRoom;

            RoomPtr     theSecondRoom;

            DoorState   theDoorState;
};

#endif // if !defined(__DOOR_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/

