
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__WALLFACTORY_HPP)
#include <WallFactory.hpp>
#endif

using namespace corelinux;

// Static instance used everywhere

WallFlyweight  WallFactory::theFlyweight;

//
// Default constructor
//

WallFactory::WallFactory( void )
   :
   AbstractAllocator<WallFlyweight>()
{
   ;  // do nothing
}

//
// Copy constructor
//

WallFactory::WallFactory( WallFactoryCref aRef )
   :
   AbstractAllocator<WallFlyweight>(aRef)
{
   ;  // do nothing
}

//
// Virtual destructor
//

WallFactory::~WallFactory( void )
{
   ;  // do nothing
}

//
// Assignment operator
//

WallFactoryRef WallFactory::operator=( WallFactoryCref aRef )
{
   if( *this == aRef )
   {
      ;  // do nothing
   }
   else
   {
      AbstractAllocator<WallFlyweight>::operator=(aRef);
   }

   return ( *this );
}

//
// Equality operator
//

bool  WallFactory::operator==( WallFactoryCref aRef ) const
{
   return ( AbstractAllocator<WallFlyweight>::operator==(aRef) );
}

//
// The overloaded allocator method invoked from AbstractAllocator
// createType
//

WallFlyweightPtr  WallFactory::allocateObject( void )
{
   return   &theFlyweight;
}

//
// The overloaded deallocator method invoked from AbstractAllocator
// destroyType
//

void  WallFactory::deallocateObject( WallFlyweightPtr aPtr )
{
   REQUIRE( aPtr != NULLPTR );
   REQUIRE( aPtr == &theFlyweight );
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/

