/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef IMPPARSER_H_INCLUDED
#define IMPPARSER_H_INCLUDED

#include <boost/shared_ptr.hpp>

#include "IMPCollector.h"
#include "IMPHeader.h"


namespace libebook
{

class IMPParser
{
  // disable copying
  IMPParser(const IMPParser &);
  IMPParser &operator=(const IMPParser &);

public:
  IMPParser(librevenge::RVNGInputStream *input, librevenge::RVNGTextInterface *document);

  bool parse();

private:
  void createTextStream();

  boost::shared_ptr<librevenge::RVNGInputStream> getFileStream(const char *name) const;

private:
  const IMPHeader m_header;
  librevenge::RVNGInputStream *const m_input;
  IMPCollector m_collector;
  boost::shared_ptr<librevenge::RVNGInputStream> m_resources;
  boost::shared_ptr<librevenge::RVNGInputStream> m_text;
};

}

#endif // IMPPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
