/** -*- C++ -*-
 * @file test-utils.h
 * @author Peter Rockai <me@mornfall.net>
 * @brief Utility functions for the unit tests
 */

#include <ept/config.h>
#include <ept/forward.h>
#include <ept/configuration/apt.h>
#include <ept/tests/tut-ept.h>
#include <ept/cache/apt/packages.h>
#include <iostream>

/* struct iterator_shar {
};*/
#define TESTGRP(name) \
    typedef test_group<name ## _shar> tg;    \
    typedef tg::object to;                          \
    tg name ## _tg (#name);

#if 0 // maybe someday...
#define TEST(n, str) \
template<> struct test_traits< typeof to, n > \
{ static const char *name() { return str; } }; \
template<> template<> void to::test<n> ()

#define TESTN(n) TEST(n, "unnamed")
#endif

template< typename T, int N > struct test_traits {};

#if 0
inline static std::string __ensure_errmsg(std::string f, int l, std::string msg)
{
    char buf[64];
    snprintf(buf, 63, "%d", l);
    buf[63] = 0;
    std::string ln = buf;
    f.append(": ");
    f.append(ln);
    f.append(": '");
    f.append(msg);
    f.append("'");
    return f;
}
#define ensure(x) ensure (__ensure_errmsg(__FILE__, __LINE__, #x).c_str(), (x))
#endif

namespace tut {

void debtagsInit();
void aptInit();

struct common {
    // ensure aptInit runs before apt::Packages ctor
    struct aptinit { aptinit() { aptInit(); } };
    aptinit foobar;
    ept::configuration::apt::cache::Packages apt;
    static std::string testCacheDir;
    static std::string testDebtagsCacheDir;
};

}
