/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CustomService.cc,v 1.3 2001/12/19 12:46:02 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/CustomService.hh>
#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;

const char *CustomService::TYPENAME={"CustomService"};

CustomService::CustomService() 
{
}

CustomService::~CustomService() {}

FWObject& CustomService::operator=(const FWObject &x)
{
    CustomService  *cs;

    if (CustomService::isA(&x)) {
	cs= (CustomService*)(&x);
	codes=cs->codes;
    }

    return FWObject::operator=(x);
}

void CustomService::fromXML(xmlNodePtr root)
{
    const char *n;
    const char *cont;

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("name")));
    if(n)  setName(n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("id")));
    if(n)  setId(n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("comment")));
    if(n)  setComment(XMLTools::unquote_linefeeds(n));

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("library")));
    if(n)  setLibrary(n);

    for(xmlNodePtr cur=root->xmlChildrenNode; cur; cur=cur->next)   {
        if(cur && !xmlIsBlankNode(cur))    {

	    n=FROMXMLCAST(xmlGetProp(cur,TOXMLCAST("platform")));
	    assert(n!=NULL);
	    cont=FROMXMLCAST( xmlNodeGetContent(cur) );
	    if (cont)
		setCodeForPlatform(n, cont );
        }
    }
}

xmlNodePtr CustomService::toXML(xmlNodePtr parent)
{
    xmlNodePtr opt;

    xmlNodePtr me = FWObject::toXML(parent);

    map<string, string>::iterator i;
    for(i=codes.begin(); i!=codes.end(); ++i)  
    {
        string platform  = (*i).first;
        string code      = (*i).second;
        
	opt=xmlNewChild(me,NULL,
			TOXMLCAST("CustomServiceCommand"), 
			STRTOXMLCAST(code));

        xmlNewProp(opt, TOXMLCAST("platform") , STRTOXMLCAST(platform));
    }
    return me;
}


void  CustomService::setCodeForPlatform(const string& platform, const string& code)
{
    codes[platform]=code;
}

const string& CustomService::getCodeForPlatform(const string& platform)
{
    return codes[platform];
}









