/**
 * @file attributes.c Attribute functions
 *
 * $Id: attribute.c,v 1.2 2001/07/28 08:39:50 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <gnurdf.h>
#include <libgnurdf/internal.h>

void
rdfSetAttribute(RdfElement *element, const char *attname, const char *value)
{
	if (element == NULL || attname == NULL || value == NULL)
		return;
	
	xmlSetProp(element, attname, value);
}

char *
rdfGetAttribute(RdfElement *element, const char *attname)
{
	if (element == NULL || attname == NULL)
		return NULL;
	
	return xmlGetProp(element, attname);
}

void
rdfSetNsAttribute(RdfElement *element, const char *attname,
				  const char *value, RdfNamespace *ns)
{
#ifndef HAVE_LIBXML2
	xmlAttrPtr att;
#endif
	
	if (element == NULL || attname == NULL || value == NULL)
		return;
	
#ifdef HAVE_LIBXML2
	xmlSetNsProp(element, ns, attname, value);
#else
	att = xmlSetProp(element, attname, value);
	att->ns = ns;
#endif
}

char *
rdfGetNsAttribute(RdfElement *element, const char *attname, RdfNamespace *ns)
{
	if (element == NULL || attname == NULL || ns == NULL)
		return NULL;
	
	return xmlGetNsProp(element, attname, rdfGetNamespaceURI(ns));
}

