/**
 * @file iterator.c Iterator functions
 *
 * $Id: iterator.c,v 1.5 2001/07/29 19:03:43 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <gnurdf.h>
#include <libgnurdf/internal.h>

RdfElement *
rdfFirstProperty(RdfContainer *container)
{
	RdfElement *element;
	
	if (container == NULL)
		return NULL;

	element = container->xmlChildrenNode;
	
	while (element != NULL && element->type != XML_ELEMENT_NODE)
		element = element->next;
	
	return element;
}

RdfElement *
rdfNextProperty(RdfElement *element)
{
	RdfElement *newElement;
	
	if (element == NULL)
		return NULL;

	newElement = element->next;
	
	while (newElement != NULL && newElement->type != XML_ELEMENT_NODE)
		newElement = newElement->next;

	return newElement;
}

/* Backwards-compatibility */

RdfElement *
rdfFirstChild(RdfContainer *container)
{
	return rdfFirstProperty(container);
}

RdfElement *
rdfNextChild(RdfElement *element)
{
	return rdfNextProperty(element);
}

