/**
 * @file search.c Search functions
 *
 * $Id: search.c,v 1.2 2001/07/07 19:42:16 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <gnurdf.h>
#include <libgnurdf/internal.h>

RdfElement *
rdfFindElementWithValue(RdfContainer *container, const char *value)
{
	RdfElement *element;
	char *elementValue;

	if (container == NULL || value == NULL)
		return NULL;

	element = rdfFirstChild(container);

	while (element != NULL)
	{
		elementValue = (char *)rdfGetElementValue(element);

		if (elementValue != NULL && (!strcmp(elementValue, value)))
		{
			free(elementValue);

			return element;
		}

		free(elementValue);

		element = rdfNextChild(element);
	}

	return NULL;
}

RdfElement *
rdfFindElementWithResource(RdfContainer *container, const char *resource)
{
	RdfElement *element;
	char *elementResource;

	if (container == NULL || resource == NULL)
		return NULL;

	element = rdfFirstChild(container);

	while (element != NULL)
	{
		elementResource = (char *)rdfGetElementResource(element);

		if (elementResource != NULL && (!strcmp(elementResource, resource)))
		{
			free(elementResource);

			return element;
		}

		free(elementResource);

		element = rdfNextChild(element);
	}

	return NULL;
}

RdfElement *
rdfGetElementFromValue(RdfContainer *container, const char *value)
{
	return rdfFindElementWithValue(container, value);
}

RdfElement *
rdfGetElementFromResource(RdfContainer *container, const char *resource)
{
	return rdfFindElementWithResource(container, resource);
}

