-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                 Copyright (C) 2010-2011, AdaCore                  --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with Cairo; use Cairo;

with Gtk.Widget; use Gtk.Widget;

package Testcairo_Drawing is

   type Test_Type is (Rectangles, Transparency, Operators, Matrix,
                      Transformations, Paths, Patterns, Clip_And_Paint,
                      Surface_And_Png, Toy_Text, Pango_Text);
   --  The supported drawing types

   procedure Draw_On_Context
     (Cr : Cairo_Context;
      Win  : Gtk_Widget;
      Test : Test_Type);
   --  Draw Test on Cr.
   --  Win is a widget used as base for creating Pango layouts.

end Testcairo_Drawing;
