#! /bin/sh -pe

# libhsync test case.
# Copyright (C) 2000 by Martin Pool

# Test the map_ptr input routines, by extracting chunks of a file
# using a known-good Python implementation, and also by passing the
# same parameters to the hsmapread driver.

# $Id: test-mapread.sh,v 1.7 2000/08/27 08:58:03 mbp Exp $

from=$srcdir/COPYING
new=$tmpdir/new.tmp
cmds=$tmpdir/cmds
expect=$tmpdir/expect

for seed in `seq 10`
do
run_test genmaptest map 1000 $cmds $expect $from $seed
run_test hsmapread $debug `cat $cmds` >$new <$from
run_test cmp $expect $new
done #seed

# the output files are pretty huge, so if we completed successfully
# delete them.  if we failed they're left behind so that you can find
# the cause of death.

run_test rm $expect $cmds $new
