/*
				Popup List
 */

#ifndef PULIST_H
#define PULIST_H

#include <gtk/gtk.h>

/*
 *	Popup Relative:
 *
 *	Indicates the type of relativity to the rel_widget.
 */
typedef enum {
	PULIST_RELATIVE_CENTER,
	PULIST_RELATIVE_UP,
	PULIST_RELATIVE_DOWN,
	PULIST_RELATIVE_ABOVE,
	PULIST_RELATIVE_BELOW
} pulist_relative;


/*
 *	Popup List:
 */
typedef struct _pulist_struct		pulist_struct;
struct _pulist_struct {

	GtkWidget	*toplevel,
			*main_vbox,
			*scrolled_window,
			*vscrollbar,
			*hscrollbar,
			*clist,
			*shadow;

	GdkPixmap	*shadow_pm;

	GtkWidget	*map_widget;	/* Shared */

	/* GTK+ block loops level */
	gint		gtk_block_level;

	/* Copy of last value */
	gchar		*last_value;

	/* Marks that the first button_press_event was sent to the
	 * clist if TRUE. This member is set FALSE at the beginning of
	 * each call to PUListMapQuery()
	 */
	gboolean	initial_list_button_press_sent;

};
#define PULIST(p)	((pulist_struct *)(p))


/*
 *	Popup List Box:
 */
typedef struct _pulistbox_struct		pulistbox_struct;
struct _pulistbox_struct {

	GtkWidget       *toplevel,
			*da,
			*map_btn;
	pulist_struct	*pulist;

	void	(*changed_cb)(
		pulistbox_struct *,	/* Popup List Box */
		gint,			/* Item */
		gpointer		/* Data */
	);
	gpointer	changed_data;

};
#define PULISTBOX(p)	((pulistbox_struct *)(p))


/* Popup List */
extern gint PUListFindItemFromValue(
	pulist_struct *list, const gchar *value
);
extern gpointer PUListGetDataFromValue(
	pulist_struct *list, const gchar *value
);
extern GtkWidget *PUListGetToplevel(pulist_struct *list);
extern GtkWidget *PUListGetCList(pulist_struct *list);

extern gint PUListAddItem(
	pulist_struct *list, const gchar *value
);
extern gint PUListAddItemPixText(
	pulist_struct *list, const gchar *value,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void PUListClear(pulist_struct *list);

extern void PUListSetItemText(
	pulist_struct *list, gint i,
	const gchar *value  
);
extern void PUListSetItemPixText(
	pulist_struct *list, gint i,
	const gchar *value,
	GdkPixmap *pixmap, GdkBitmap *mask
);
extern void PUListSetItemData(
	pulist_struct *list, gint i,
	gpointer data
);
extern void PUListSetItemDataFull(
	pulist_struct *list, gint i,
	gpointer data, GtkDestroyNotify destroy_cb
);

extern void PUListGetItemText(
	pulist_struct *list, gint i,
	gchar **value
);
extern void PUListGetItemPixText(
	pulist_struct *list, gint i,
	gchar **value,
	GdkPixmap **pixmap, GdkBitmap **mask
);
extern gpointer PUListGetItemData(pulist_struct *list, gint i);

extern gint PUListGetSelectedLast(pulist_struct *list);
extern void PUListSelect(pulist_struct *list, gint i);
extern void PUListUnselectAll(pulist_struct *list);

extern gboolean PUListIsQuery(pulist_struct *list);
extern void PUListBreakQuery(pulist_struct *list);
extern const gchar *PUListMapQuery(
	pulist_struct *list,
	const gchar *value,		/* Initial value */
	gint lines_visible,		/* Can be -1 for default */
	pulist_relative relative,	/* One of PULIST_RELATIVE_* */
	GtkWidget *rel_widget,		/* Map relative to this widget */
	GtkWidget *map_widget		/* Widget that mapped this list */
);

extern pulist_struct *PUListNew(void);
extern void PUListDelete(pulist_struct *list);


/* Map Button */
extern GtkWidget *PUListNewMapButton(
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);
extern GtkWidget *PUListNewMapButtonArrow(
	GtkArrowType arrow_type, GtkShadowType shadow_type,
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);


/* Popup List Box */
extern GtkWidget *PUListBoxGetToplevel(pulistbox_struct *box);
extern pulist_struct *PUListBoxGetPUList(pulistbox_struct *box);

extern pulistbox_struct *PUListBoxNew(
	GtkWidget *parent,
	gint width, gint height
);
extern void PUListBoxSetChangedCB(
	pulistbox_struct *box,
	void (*func)(
		pulistbox_struct *,	/* Popup List Box */
		gint,			/* Item */         
		gpointer		/* Data */ 
	),
	gpointer data
);
extern void PUListBoxMap(pulistbox_struct *box);
extern void PUListBoxUnmap(pulistbox_struct *box);
extern void PUListBoxDelete(pulistbox_struct *box);


#endif	/* PULIST_H */
