//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIFLISTVIEWITEM_H
#define KEXIFLISTVIEWITEM_H

#include <qlistview.h>
#include <qcolor.h>

class KExifEntry;

class KExifListViewItem : public QListViewItem
{
public:

    KExifListViewItem(QListView *parent, KExifEntry* entry,
                      const QColor& color);

    KExifEntry* exifEntry() const;
    void setSortKey(int key);
    int  compare(QListViewItem * i, int col, bool ascending) const;

protected:

    void paintCell(QPainter * p, const QColorGroup & cg,
                   int column, int width, int paintCell);
    
private:

    KExifEntry* m_exifEntry;
    int         m_key;
    QColor      m_color;
};

#endif
