#!/usr/bin/env ruby-1.4
#
# extconf.rb for ldap extension
# $Id: extconf.rb,v 1.41 2002/04/02 09:18:05 ttate Exp $
#

require 'mkmf'

$INTERACTIVE = false

if( ARGV.include?("--help") )
  print <<EOF
  --with-ldap-dir    specify the ldap directory.
  --with-ldap-incdir specify the directory which contains ldap.h and lber.h.
  --with-ldap-libdir specify the directory which contains ldap libraries.
  --with-netscape    use this option, if you use Netscape SDK.
  --with-openldap1   use this option, if you use OpenLDAP-1.x.
  --with-openldap2   use this option, if you use OpenLDAP-2.x.
  --with-wldap32     use this option, if you use Active Directory Client API.

The follows are library configuration options:
  --with-libcrypto=crypto,   --without-libcrypto
  --with-libssl=ssl,         --without-libssl
  --with-libnsl=nsl,         --without-libnsl
  --with-libldap=ldap,       --without-libldap
  --with-liblber=lber,       --without-liblber
  --with-libldap_r=ldap_r,   --without-libldap_r
  --with-libpthread=pthread, --without-libpthread
  --with-libresolv=resolv,   --without-libresolv

  --help             show this help.
EOF
exit(0)
end

def find_files(dir = nil)
  if( dir )
    search_dirs = [dir]
  else
    search_dirs =
      ["/usr/local", "/usr", "/opt"] +
      Dir.glob("/usr/local/./*ldap*").collect{|d| d.gsub(/\/\.\//, "/")} +
      Dir.glob("/usr/./*ldap*").collect{|d| d.gsub(/\/\.\//, "/")}
  end
  for d in search_dirs
    h = File.join(d,"include","ldap.h")
    l = File.join(d,"lib","libldap*")
    if( File.exist?(h) )
      l = Dir.glob(l)[0]
      if( l )
	if( $INTERACTIVE )
	  print("--with-ldap-dir=#{d} [y/n]")
	  ans = $stdin.gets
	  ans.chop!
	  if( ans == "y" )
	    result = [d, File.basename(l).split(".")[0][3..-1], File.basename(h)]
	    return result
	    break
	  end
	else
	  print("--with-ldap-dir=#{d}\n")
	  result = [d, File.basename(l).split(".")[0][3..-1], File.basename(h)]
	  return result
	  break
	end
      end
    end
  end
end

def ldap_with_config(arg, default = nil)
  cfg1  = with_config(arg, nil)
  cfg2  = arg_config("--without-" + arg, nil)
  if( cfg1 )
    return cfg1
  else
    if( cfg2 )
      return nil
    else
      return default
    end
  end
end


if( ! $CFLAGS )
#  $CFLAGS = "-D_REENTRANT"
  $CFLAGS = ""
end

if( ! $LDFLAGS )
  $LDFLAGS = ""
end

$use_netscape  = ldap_with_config("netscape")
$use_openldap1 = ldap_with_config("openldap1")
$use_openldap2 = ldap_with_config("openldap2")
$use_wldap32   = ldap_with_config("wldap32")

$ldap_dir    = ldap_with_config("ldap-dir") || ldap_with_config("ldap")
$ldap_incdir = ldap_with_config("ldap-incdir")
$ldap_libdir = ldap_with_config("ldap-libdir")

$ldap_dir, $libldap, $ldap_h = find_files($ldap_dir)

if( !($use_netscape || $use_openldap1 || $use_openldap2 || $use_wldap32) )
  if( $libldap =~ /^ldapssl[0-9]+$/ )
    print("--with-netscape\n")
    $use_netscape = true
  else
    print("--with-openldap2\n")
    $use_openldap2 = true
  end
end


if( $use_netscape )
  $CFLAGS += " -DUSE_NETSCAPE_SDK"
  #$libnsl     = ldap_with_config("libnsl", "nsl")
  #$libpthread = ldap_with_config("libpthread", "pthread")
  $libresolv  = ldap_with_config("libresolv", "resolv")
  $libldap    = ldap_with_config("libldap", $libldap)
  $libns      = ldap_with_config("libns", "nspr3,plc3,plds3").split(",")
end

if( $use_openldap1 )
  $CFLAGS += " -DUSE_OPENLDAP1 -DUSE_OPENLDAP"
  $libresolv  = ldap_with_config("libresolv", "resolv")
  $libldap   = ldap_with_config("libldap", "ldap")
  $liblber   = ldap_with_config("liblber", "lber")
end

if( $use_openldap2 )
  $CFLAGS += " -DUSE_OPENLDAP2 -DUSE_OPENLDAP"
  $libresolv  = ldap_with_config("libresolv", "resolv")
  $libcrypto  = ldap_with_config("libcrypto", "crypto")
  $libssl     = ldap_with_config("libssl", "ssl")
  $libpthread = ldap_with_config("libpthread", "pthread")
  $libnsl     = ldap_with_config("libnsl", "nsl")
  $liblber    = ldap_with_config("liblber", "lber")
  $libldap_r  = ldap_with_config("libldap_r", "ldap_r")
  $libldap    = ldap_with_config("libldap", "ldap")
end

if( $use_wldap32 )
  if( !File.exist?("win/wldap32.lib") && File.exist?("win/wldap32.def") )
    `dlltool --dllname wldap32.dll --input-def win/wldap32.def --output-lib win/wldap32.lib`
    $CFLAGS += " -DUSE_WLDAP32 -I./win"
    $LDFLAGS += " -L./win"
    $libldap = ldap_with_config("libldap", "wldap32")
  end
  if( !File.exist?("win/wldap32.lib") && File.exist?("../win/wldap32.def") )
    Dir.mkdir("win")
    `dlltool --dllname wldap32.dll --input-def ../win/wldap32.def --output-lib win/wldap32.lib`
    $CFLAGS += " -DUSE_WLDAP32 -I../win"
    $LDFLAGS += " -L../win"
    $libldap = ldap_with_config("libldap", "wldap32")
  end
end

if( $ldap_dir )
  $CFLAGS  += " -I" + File.join($ldap_dir,"include")
  $LDFLAGS += " -L" + File.join($ldap_dir,"lib")
end

if( $ldap_incdir )
  $CFLAGS += " -I" + $ldap_incdir
end

if( $ldap_libdir )
  $LDFLAGS += " -L" + $ldap_libdir
end

if( $libpthread )
  $CFLAGS += " -D_REENTRANT"
end

if( $use_wldap32 )
  have_header("winldap.h")
  have_header("winlber.h")
  have_header("sys/time.h")
else
  ldap_h = have_header("ldap.h")
  lber_h = have_header("lber.h")
  ldap_ssl_h = have_header("ldap_ssl.h")
  if( !(ldap_h && lber_h) )
    print("can't find ldap.h and lber.h\n")
    print("use the option '--with-ldap-dir'!\n")
    exit(0)
  end

  have_header("openssl/ssl.h")    || have_header("ssl.h")
  have_header("openssl/crypto.h") || have_header("crypto.h")
end

for l in [$libcrypto, $libssl, $libnsl, $libpthread, $libresolv,
          $libns, $liblber, $libldap_r, $libldap].flatten
  if( l )
    have_library(l)
  end
end

have_func("ldap_init")
have_func("ldap_set_option")
have_func("ldap_get_option")
have_func("ldap_start_tls_s") if $use_openldap2
have_func("ldap_memfree")
have_func("ldap_perror") if !arg_config("--disable-ldap-perror")
have_func("ldap_sort_entries")
#have_func("ldap_sort_values")
have_func("ldapssl_init")  # NS SDK
have_func("ldap_sslinit")  # WLDAP32
have_func("ldap_sasl_bind_s")
have_func("ldap_compare_s")

print("CFLAGS = #{$CFLAGS}\n")
print("LDFLAGS = #{$LDFLAGS}\n")

create_makefile("ldap")


$slapd = ldap_with_config("slapd") || File.join($ldap_dir,"libexec","slapd")
$schema_dir = ldap_with_config("schema-dir")
if( !$schema_dir )
  $schema_dir = File.join($ldap_dir,"etc","openldap","schema")
  if( !File.exist?($schema_dir) )
    $schema_dir = File.join($ldap_dir,"etc","openldap")
  end
end

$run_test = "/bin/sh test/test.sh"
if( $use_openldap1 )
  $run_test += " openldap1"
else( $use_openldap2 )
  if( $libssl && $libcrypto )
    $run_test = "/bin/sh test/test.sh newcert; " + $run_test
    $run_test += " openldap2-ssl"
  else
    $run_test += " openldap2"
  end
end
$run_test += " #{$slapd} #{$schema_dir}"
$run_test = "(cd $(srcdir); " + $run_test + ")"


File.open("Makefile","a"){|f|
  f.print <<EOF

test::
\t#{$run_test}

testclean: test-clean

test-clean::
\t(cd $(srcdir); /bin/sh test/test.sh clean)

reconfig::
\t$(RUBY_INSTALL_NAME) $(srcdir)/extconf.rb #{ARGV.join(" ")}
EOF
}
