//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QCURSOR_C_H
#define QCURSOR_C_H

#include <QtGui>
#include "pascalbind.h"

C_EXPORT QCursorH QCursor_create();
C_EXPORT void QCursor_destroy(QCursorH handle);
C_EXPORT QCursorH QCursor_create2(Qt::CursorShape shape);
C_EXPORT QCursorH QCursor_create3(const QBitmapH bitmap, const QBitmapH mask, int hotX, int hotY);
C_EXPORT QCursorH QCursor_create4(const QPixmapH pixmap, int hotX, int hotY);
C_EXPORT QCursorH QCursor_create5(const QCursorH cursor);
C_EXPORT Qt::CursorShape QCursor_shape(QCursorH handle);
C_EXPORT void QCursor_setShape(QCursorH handle, Qt::CursorShape newShape);
C_EXPORT const QBitmapH QCursor_bitmap(QCursorH handle);
C_EXPORT const QBitmapH QCursor_mask(QCursorH handle);
C_EXPORT void QCursor_pixmap(QCursorH handle, QPixmapH retval);
C_EXPORT void QCursor_hotSpot(QCursorH handle, PQtPoint retval);
C_EXPORT void QCursor_pos(PQtPoint retval);
C_EXPORT void QCursor_setPos(int x, int y);
C_EXPORT void QCursor_setPos2(const QPointH p);
#if defined BINUX || DARWIN
C_EXPORT Qt::HANDLE QCursor_handle(QCursorH handle);
#endif
#if defined BINUX
C_EXPORT QCursorH QCursor_create6(Qt::HANDLE cursor);
C_EXPORT int QCursor_x11Screen();
#endif
#if defined MSWINDOWS
C_EXPORT HCURSOR QCursor_handle2(QCursorH handle);
C_EXPORT QCursorH QCursor_create7(HCURSOR cursor);
#endif
#if defined QTOPIA
C_EXPORT int QCursor_handle3(QCursorH handle);
#endif

#endif
