//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QURL_C_H
#define QURL_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QUrlH QUrl_create();
C_EXPORT void QUrl_destroy(QUrlH handle);
C_EXPORT QUrlH QUrl_create2(PWideString url);
C_EXPORT QUrlH QUrl_create3(PWideString url, QUrl::ParsingMode mode);
C_EXPORT QUrlH QUrl_create4(const QUrlH copy);
C_EXPORT void QUrl_setUrl(QUrlH handle, PWideString url);
C_EXPORT void QUrl_setUrl2(QUrlH handle, PWideString url, QUrl::ParsingMode mode);
C_EXPORT void QUrl_setEncodedUrl(QUrlH handle, const QByteArrayH url);
C_EXPORT void QUrl_setEncodedUrl2(QUrlH handle, const QByteArrayH url, QUrl::ParsingMode mode);
C_EXPORT bool QUrl_isValid(QUrlH handle);
C_EXPORT bool QUrl_isEmpty(QUrlH handle);
C_EXPORT void QUrl_clear(QUrlH handle);
C_EXPORT void QUrl_setScheme(QUrlH handle, PWideString scheme);
C_EXPORT void QUrl_scheme(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setAuthority(QUrlH handle, PWideString authority);
C_EXPORT void QUrl_authority(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setUserInfo(QUrlH handle, PWideString userInfo);
C_EXPORT void QUrl_userInfo(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setUserName(QUrlH handle, PWideString userName);
C_EXPORT void QUrl_userName(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setEncodedUserName(QUrlH handle, const QByteArrayH userName);
C_EXPORT void QUrl_encodedUserName(QUrlH handle, QByteArrayH retval);
C_EXPORT void QUrl_setPassword(QUrlH handle, PWideString password);
C_EXPORT void QUrl_password(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setEncodedPassword(QUrlH handle, const QByteArrayH password);
C_EXPORT void QUrl_encodedPassword(QUrlH handle, QByteArrayH retval);
C_EXPORT void QUrl_setHost(QUrlH handle, PWideString host);
C_EXPORT void QUrl_host(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setEncodedHost(QUrlH handle, const QByteArrayH host);
C_EXPORT void QUrl_encodedHost(QUrlH handle, QByteArrayH retval);
C_EXPORT void QUrl_setPort(QUrlH handle, int port);
C_EXPORT int QUrl_port(QUrlH handle);
C_EXPORT int QUrl_port2(QUrlH handle, int defaultPort);
C_EXPORT void QUrl_setPath(QUrlH handle, PWideString path);
C_EXPORT void QUrl_path(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setEncodedPath(QUrlH handle, const QByteArrayH path);
C_EXPORT void QUrl_encodedPath(QUrlH handle, QByteArrayH retval);
C_EXPORT bool QUrl_hasQuery(QUrlH handle);
C_EXPORT void QUrl_setEncodedQuery(QUrlH handle, const QByteArrayH query);
C_EXPORT void QUrl_encodedQuery(QUrlH handle, QByteArrayH retval);
C_EXPORT void QUrl_setQueryDelimiters(QUrlH handle, char valueDelimiter, char pairDelimiter);
C_EXPORT char QUrl_queryValueDelimiter(QUrlH handle);
C_EXPORT char QUrl_queryPairDelimiter(QUrlH handle);
C_EXPORT void QUrl_addQueryItem(QUrlH handle, PWideString key, PWideString value);
C_EXPORT bool QUrl_hasQueryItem(QUrlH handle, PWideString key);
C_EXPORT void QUrl_queryItemValue(QUrlH handle, PWideString retval, PWideString key);
C_EXPORT void QUrl_allQueryItemValues(QUrlH handle, QStringListH retval, PWideString key);
C_EXPORT void QUrl_removeQueryItem(QUrlH handle, PWideString key);
C_EXPORT void QUrl_removeAllQueryItems(QUrlH handle, PWideString key);
C_EXPORT void QUrl_addEncodedQueryItem(QUrlH handle, const QByteArrayH key, const QByteArrayH value);
C_EXPORT bool QUrl_hasEncodedQueryItem(QUrlH handle, const QByteArrayH key);
C_EXPORT void QUrl_encodedQueryItemValue(QUrlH handle, QByteArrayH retval, const QByteArrayH key);
C_EXPORT void QUrl_removeEncodedQueryItem(QUrlH handle, const QByteArrayH key);
C_EXPORT void QUrl_removeAllEncodedQueryItems(QUrlH handle, const QByteArrayH key);
C_EXPORT void QUrl_setFragment(QUrlH handle, PWideString fragment);
C_EXPORT void QUrl_fragment(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_setEncodedFragment(QUrlH handle, const QByteArrayH fragment);
C_EXPORT void QUrl_encodedFragment(QUrlH handle, QByteArrayH retval);
C_EXPORT bool QUrl_hasFragment(QUrlH handle);
C_EXPORT void QUrl_resolved(QUrlH handle, QUrlH retval, const QUrlH relative);
C_EXPORT bool QUrl_isRelative(QUrlH handle);
C_EXPORT bool QUrl_isParentOf(QUrlH handle, const QUrlH url);
C_EXPORT void QUrl_fromLocalFile(QUrlH retval, PWideString localfile);
C_EXPORT void QUrl_toLocalFile(QUrlH handle, PWideString retval);
C_EXPORT void QUrl_toString(QUrlH handle, PWideString retval, unsigned int options);
C_EXPORT void QUrl_toEncoded(QUrlH handle, QByteArrayH retval, unsigned int options);
C_EXPORT void QUrl_fromEncoded(QUrlH retval, const QByteArrayH url);
C_EXPORT void QUrl_fromEncoded2(QUrlH retval, const QByteArrayH url, QUrl::ParsingMode mode);
C_EXPORT void QUrl_detach(QUrlH handle);
C_EXPORT bool QUrl_isDetached(QUrlH handle);
C_EXPORT void QUrl_fromPercentEncoding(PWideString retval, const QByteArrayH p1);
C_EXPORT void QUrl_toPercentEncoding(QByteArrayH retval, PWideString p1, const QByteArrayH exclude, const QByteArrayH include);
C_EXPORT void QUrl_fromPunycode(PWideString retval, const QByteArrayH p1);
C_EXPORT void QUrl_toPunycode(QByteArrayH retval, PWideString p1);
C_EXPORT void QUrl_fromAce(PWideString retval, const QByteArrayH p1);
C_EXPORT void QUrl_toAce(QByteArrayH retval, PWideString p1);
C_EXPORT void QUrl_idnWhitelist(QStringListH retval);
C_EXPORT void QUrl_setIdnWhitelist(const QStringListH p1);
C_EXPORT void QUrl_errorString(QUrlH handle, PWideString retval);

#endif
