/*
	sample xmlrpc function providers for caudium

   (c) 1999 Martin Baehr
   (c) 2001 Karl Pitrich

   This program is free software; you can redistribute it and/or modify it *
   under the terms of the GNU General Public License as published by the   *
   Free Software Foundation; either version 2 of the License, or (at your  *
   option) any later version.     
   
   CHANGELOG:
      -fixed array type handling (pit, 2001-03-30)
      -class framework (pit, 2001-03-30)
*/

constant cvs_version="$Id: xml-rpc-provider.pike,v 1.2 2001/04/10 18:31:32 pit Exp $";

#include <module.h>
#include <stdio.h>
inherit "module";
inherit "caudiumlib";

static private string doc()
{
    return "doku\n";
}

array register_module()
{
  return ({ MODULE_PROVIDER, "XML-RPC-Provider: foo.",
            ""+doc()
            ,0,1 });
}

string|array(string) query_provides() 
{
	return "XML-RPC";
}

mapping query_rpc_functions()
{
	return ([ "test_a" : test_a,
				 "test_m" : test_m,
				 "test_i" : test_i,
				 "test_s" : test_s 
	]);
}


array test_a(void|int val) {
	array ret=({"aaa", "bbb", "ccc", "ddd"});

	return(ret);
}

mapping test_m(void|int val) {
	mapping my_urls=([]); 
	foreach(caudium->configurations, mixed this) {
		if(strlen(this->query("MyWorldLocation"))) {
			my_urls+=([ this->name : this->query("MyWorldLocation") ]);
		}
	}
	return(my_urls);
}

int test_i(void|int val)	{
	return val+1;
}

string test_s(void|string s) {
	return s+" ok.\n";
}

