/* TableColumnIcon.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.tables;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

/**
 * Simple table column decoration that displays a fixed icon and does not
 * interpret mouse events.
 */
public class TableColumnIcon implements TableColumnDecoration {
    
    //
    private final Icon icon;
    
    //
    public TableColumnIcon copy () {
        try {
            return (TableColumnIcon)super.clone ();
        } catch (CloneNotSupportedException e) {
            assert false : "Unexpected exception";
            return null;
        }
    }
    
    /**
     * Create a decoration for the given icon.
     */
    public TableColumnIcon (Icon icon) {
        this.icon = icon;
    }
    
    /**
     * Return the height of this decoration.
     */
    public int getDecorationHeight () {
        return icon.getIconHeight ();
    }
    
    /**
     * Return the width of this decoration.
     */
    public int getDecorationWidth () {
        return icon.getIconWidth ();
    }
    
    /**
     * Paint this decoration.
     */
    public void paintDecoration (Component c, Graphics g, int x, int y) {
        icon.paintIcon (c,g,x,y);
    }
    
    public void mouseReleased () {
        // trivial implementation
    }
    
    public void mousePressed () {
        // trivial implementation
    }
    
    public void mouseExited () {
        // trivial implementation
    }
    
    public void mouseEntered () {
        // trivial implementation
    }
    
    public void setColumnIndex (int columnIndex) {
        // trivial implementation
    }
    
    
}
