/* Libvoikko: Library of Finnish language tools
 * Copyright (C) 2009 Harri Pitkänen <hatapitk@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *********************************************************************************/

#ifndef VOIKKO_GRAMMAR_PARAGRAPH
#define VOIKKO_GRAMMAR_PARAGRAPH

#include "grammar/Sentence.hpp"

namespace libvoikko { namespace grammar {

/**
 * Analyzed paragraph for grammar checker. The user of this class
 * must ensure that sentenceCount matches the number of sentences
 * stored in this paragraph.
 */
class Paragraph {
	public:
		Paragraph();
		
		~Paragraph();
		
		/* Maximum number of sentences in a paragraph */
		static const size_t MAX_SENTENCES_IN_PARAGRAPH = 200;
		
		/** Pointers to analyzed sentences */
		Sentence ** sentences;
		
		/** Number of sentences in the paragraph */
		size_t sentenceCount;
	
	private:
		Paragraph(Paragraph const & other);
		Paragraph & operator = (const Paragraph & other);
};

} }

#endif
