/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.externalizer;

import xdoclet.DocletContext;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.util.Translator;

/**
 * Tags used in generating &amp; using externalised property resource bundles.
 *
 * @author               Ara Abrahamian (ara_e_w@yahoo.com)
 * @created              May 30, 2002
 * @xdoclet.taghandler   namespace="Externalizer"
 * @version              $Revision: 1.7 $
 */
public class ExternalizerTagsHandler extends XDocletTagSupport
{
    private String  currentKey;
    private String  currentValue;

    /**
     * Convert native encoding character to escaped character.
     *
     * @param str  string with native characters
     * @return     string with unicode escapes
     */
    private static String convertToUnicodeEscape(String str)
    {
        StringBuffer buf = new StringBuffer();

        buf.setLength(0);

        int pos = 0;

        while (pos < str.length()) {
            char c = str.charAt(pos);

            pos++;
            if (c >= 0x100) {
                // Only characters >8 bit -- leave iso-8859-x alone
                String hex = Integer.toHexString(c);

                buf.append("\\u0000".substring(0, 6 - hex.length()));
                buf.append(hex);
            }
            else {
                switch (c) {
                case '\t':
                    buf.append("\\t");
                    break;
                default:
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    /**
     * Evaluate the body for all field tags. Works only in context of {@link ExternalizerSubTask externalizer} subtask.
     *
     * @param template              The body of the block tag
     * @exception XDocletException
     * @doc.tag                     type="block"
     */
    public void forAllFieldTags(String template) throws XDocletException
    {
        ExternalizerSubTask.Combination combination = ((ExternalizerSubTask) getDocletContext().getActiveSubTask()).getCurrentCombination();

        for (int i = 0; i < combination.keys.size(); i++) {
            currentKey = (String) combination.keys.get(i);
            currentValue = (String) combination.values.get(i);

            generate(template);
        }

        currentKey = null;
        currentValue = null;
    }

    /**
     * Current resource bundle name, will be called by {@link PropertiesTranslatorSubTask propertiestranslator} subtask.
     *
     * @return                      bundle name
     * @exception XDocletException
     * @doc.tag                     type="content"
     */
    public String bundleKey() throws XDocletException
    {
        if (DocletContext.getInstance().isSubTaskDefined(DocletTask.getSubTaskName(ExternalizerSubTask.class))) {
            return ((ExternalizerSubTask) DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(ExternalizerSubTask.class))).getBundleKey(getCurrentClass());
        }
        else {
            throw new XDocletException(Translator.getString("xdoclet.modules.externalizer.ExternalizerSubtaskMessages",
                ExternalizerSubtaskMessages.TRANSLATOR_DEPENDS_ON_EXTERNALIZER));
        }
    }

    /**
     * The current key.
     *
     * @return                      key
     * @exception XDocletException
     * @doc.tag                     type="content"
     */
    public String key() throws XDocletException
    {
        return currentKey;
    }

    /**
     * The current value, with Unicode escapes where necessary.
     *
     * @return                      value
     * @exception XDocletException
     * @doc.tag                     type="content"
     */
    public String value() throws XDocletException
    {
        return convertToUnicodeEscape(currentValue);
    }
}
