.TH "ZIP_DIR_ADD" "3" "June 23, 2012" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_dir_add\fR
\- add directory to zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.br
\fBzip_dir_add\fR(\fIstruct zip *archive\fR,\ \fIconst char *name\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The function
\fBzip_dir_add\fR()
adds a directory to a zip archive.
The argument
\fIarchive\fR
specifies the zip archive to which the directory should be added.
\fIname\fR
is the directory's name in the zip archive.
The
\fIflags\fR
argument can be any of:
.TP 22n
\fRZIP_FL_ENC_GUESS\fR
Guess encoding of
\fIname\fR
(default).
.TP 22n
\fRZIP_FL_ENC_UTF_8\fR
Interpret
\fIname\fR
as UTF-8.
.TP 22n
\fRZIP_FL_ENC_CP437\fR
Interpret
\fIname\fR
as code page 437 (CP-437).
.SH "RETURN VALUES"
Upon successful completion, the index of the new entry in the archive
is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_dir_add\fR()
fails if:
.TP 19n
[\fRZIP_ER_EXISTS\fR]
There is already an entry called
\fIname\fR
in the archive.
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIarchive\fR
or
\fIname\fR
are
\fRNULL\fR,
or invalid UTF-8 encoded file names.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
