/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: zorplib.h,v 1.10 2003/04/08 13:32:29 sasa Exp $
 *
 ***************************************************************************/
#ifndef ZORPLIB_RANDOM_H_INCLUDED
#define ZORPLIB_RANDOM_H_INCLUDED

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define Z_RANDOM_STRONG 0
#define Z_RANDOM_BASIC  1
#define Z_RANDOM_WEAK   2

gboolean z_random_sequence_get_bounded(guchar *target,
                                        guint  len,
                                       guchar  min,
                                       guchar  max,
                                        guint  type);

#define z_random_sequence_get(target, len, type) z_random_sequence_get_bounded(target, len, 0, 255, type)

#ifdef __cplusplus
}
#endif

#endif
